/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.domain;

import com.google.common.base.Objects;
import java.io.File;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.serenitybdd.model.collect.NewList;
import net.serenitybdd.model.di.ModelInfrastructure;
import net.serenitybdd.model.rest.RestQuery;
import net.serenitybdd.model.time.SystemClock;
import net.thucydides.model.domain.ErrorMessageFormatter;
import net.thucydides.model.domain.ExternalLink;
import net.thucydides.model.domain.ReportData;
import net.thucydides.model.domain.TestDuration;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.domain.TestResultComparison;
import net.thucydides.model.domain.TestResultList;
import net.thucydides.model.domain.failures.FailureAnalysis;
import net.thucydides.model.domain.screenshots.Screenshot;
import net.thucydides.model.domain.stacktrace.FailureCause;
import net.thucydides.model.domain.stacktrace.RootCauseAnalyzer;
import net.thucydides.model.images.ResizableImage;
import net.thucydides.model.requirements.reports.CompoundDuration;
import net.thucydides.model.screenshots.ScreenshotAndHtmlSource;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;

public class TestStep
implements Cloneable {
    public static final TestStep NO_STEP = new TestStep("NO STEP");
    private int number;
    private String description;
    private long duration;
    private ZonedDateTime startTime;
    private List<ScreenshotAndHtmlSource> screenshots = new ArrayList<ScreenshotAndHtmlSource>();
    private FailureCause exception;
    private TestResult result;
    private RestQuery restQuery;
    private List<ReportData> reportData;
    private boolean precondition;
    private int level;
    private Integer lineNumber;
    private ExternalLink externalLink;
    private Boolean manual;
    public static final Predicate<TestStep> IGNORED_TESTSTEPS = testStep -> testStep.getResult() == TestResult.IGNORED;
    public static final Predicate<TestStep> COMPROMISED_TESTSTEPS = testStep -> testStep.getResult() == TestResult.COMPROMISED;
    public static final Predicate<TestStep> SUCCESSFUL_TESTSTEPS = testStep -> testStep.getResult() == TestResult.SUCCESS;
    public static final Predicate<TestStep> FAILING_TESTSTEPS = testStep -> testStep.getResult() == TestResult.FAILURE;
    public static final Predicate<TestStep> ERROR_TESTSTEPS = testStep -> testStep.getResult() == TestResult.ERROR;
    public static final Predicate<TestStep> SKIPPED_TESTSTEPS = testStep -> testStep.getResult() == TestResult.SKIPPED;
    private List<TestStep> children = new ArrayList<TestStep>();
    private TestResult overallResult;

    public TestStep() {
        this.startTime = ModelInfrastructure.getClock().getCurrentTime();
    }

    protected void setNumber(int number) {
        this.number = number;
    }

    private SystemClock getSystemClock() {
        return ModelInfrastructure.getClock();
    }

    private ZonedDateTime now() {
        return this.getSystemClock().getCurrentTime();
    }

    public static TestStepBuilder forStepCalled(String description) {
        return new TestStepBuilder(description);
    }

    public boolean hasScreenshots() {
        return !this.getScreenshots().isEmpty();
    }

    protected List<TestStep> children() {
        return this.children;
    }

    public int renumberFrom(int count) {
        this.number = count++;
        if (!this.children.isEmpty()) {
            count = this.renumberChildrenFrom(count);
        }
        return count;
    }

    private int renumberChildrenFrom(int count) {
        for (TestStep step : this.children) {
            count = step.renumberFrom(count);
        }
        return count;
    }

    public void recordRestQuery(RestQuery restQuery) {
        this.restQuery = restQuery;
    }

    public void updateOverallResult() {
        if (this.result != null && this.getResultFromChildren().overrides(this.result)) {
            this.result = null;
        }
    }

    public void setPrecondition(boolean precondition) {
        this.precondition = precondition;
    }

    public TestStep withResult(TestResult annotatedResult) {
        TestStep annotatedStep = this.clone();
        annotatedStep.result = annotatedResult;
        return annotatedStep;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public boolean correspondsToLine(int lineNumber) {
        return this.lineNumber != null && this.lineNumber == lineNumber;
    }

    public ExternalLink getExternalLink() {
        return this.externalLink;
    }

    public void setExternalLink(ExternalLink externalLink) {
        this.externalLink = externalLink;
    }

    public void setStartTime(ZonedDateTime startTime) {
        this.startTime = startTime;
    }

    public String toString() {
        if (!this.hasChildren()) {
            return this.description;
        }
        String childDescriptions = this.children.stream().map(TestStep::toString).collect(Collectors.joining(", "));
        return this.description + " [" + childDescriptions + "]";
    }

    public TestStep(String description) {
        this();
        this.description = description;
        this.level = 0;
    }

    public TestStep(ZonedDateTime startTime, String description) {
        this();
        this.startTime = startTime;
        this.description = description;
        this.level = 0;
    }

    public TestStep startingAt(ZonedDateTime time) {
        TestStep newTestStep = this.copyOfThisTestStep();
        newTestStep.startTime = time;
        return newTestStep;
    }

    public TestStep clone() {
        TestStep newTestStep = new TestStep();
        newTestStep.description = this.description;
        newTestStep.startTime = this.startTime;
        newTestStep.duration = this.duration;
        newTestStep.screenshots = NewList.copyOf(this.screenshots);
        newTestStep.exception = this.exception;
        newTestStep.result = this.result;
        newTestStep.number = this.number;
        newTestStep.children = NewList.copyOf(this.children);
        newTestStep.precondition = this.precondition;
        newTestStep.level = this.level;
        return newTestStep;
    }

    protected TestStep copyOfThisTestStep() {
        return this.clone();
    }

    public void recordDuration(ZonedDateTime time) {
        this.setDuration(ChronoUnit.MILLIS.between(this.startTime, time));
    }

    public void recordDuration() {
        this.recordDuration(this.now());
    }

    public int getNumber() {
        return this.number;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public TestStep unrendered() {
        TestStep stepCopy = this.clone();
        stepCopy.setDescription(this.stripMarkupFrom(this.description));
        return stepCopy;
    }

    private String stripMarkupFrom(String description) {
        return Jsoup.parse((String)description).text();
    }

    public List<TestStep> getChildren() {
        return new ArrayList<TestStep>(this.children);
    }

    public List<ScreenshotAndHtmlSource> getScreenshots() {
        return new ArrayList<ScreenshotAndHtmlSource>(this.screenshots);
    }

    public List<ScreenshotAndHtmlSource> getAllScreenshots() {
        Set allScreenshots = this.children.stream().flatMap(child -> child.getAllScreenshots().stream()).collect(Collectors.toSet());
        allScreenshots.addAll(this.screenshots);
        ArrayList<ScreenshotAndHtmlSource> screenshotInOrderOfAppearance = new ArrayList<ScreenshotAndHtmlSource>(this.screenshots);
        screenshotInOrderOfAppearance.sort(Comparator.comparingLong(ScreenshotAndHtmlSource::getTimeStamp));
        return screenshotInOrderOfAppearance;
    }

    public List<Screenshot> getRenderedScreenshots() {
        ArrayList<Screenshot> stepScreenshots = this.screenshots == null ? new ArrayList<Screenshot>() : this.screenshots.stream().map(screenshot -> this.renderedScreenshotOf((ScreenshotAndHtmlSource)screenshot, this.getLevel())).collect(Collectors.toList());
        this.children.forEach(child -> stepScreenshots.addAll(child.getRenderedScreenshots()));
        stepScreenshots.sort(Comparator.comparingLong(Screenshot::getTimestamp));
        if (!stepScreenshots.isEmpty()) {
            Screenshot earliestScreenshot = (Screenshot)stepScreenshots.get(0);
            Screenshot lastScreenshot = (Screenshot)stepScreenshots.get(stepScreenshots.size() - 1);
            if (this.isScreenshotInThisStep(lastScreenshot) && lastScreenshot.getTimestamp() > earliestScreenshot.getTimestamp()) {
                stepScreenshots.remove(stepScreenshots.size() - 1);
                stepScreenshots.add(this.withClosingDescriptionForThisStep(lastScreenshot.withDepth(this.level)));
            }
            if (this.thereAreNoScreenshotsInThisStep() || !this.isScreenshotInThisStep(earliestScreenshot)) {
                stepScreenshots.add(0, this.withDescriptionForThisStep(earliestScreenshot.withDepth(this.level)));
            }
        }
        return stepScreenshots;
    }

    private Screenshot withClosingDescriptionForThisStep(Screenshot screenshot) {
        return screenshot.withDescription(screenshot.getDescription() + " (completed)");
    }

    private Screenshot withDescriptionForThisStep(Screenshot screenshot) {
        return screenshot.before().withDescription(this.getDescription());
    }

    private boolean isScreenshotInThisStep(Screenshot screenshot) {
        return screenshot.getDescription().equals(this.getDescription());
    }

    private boolean thereAreNoScreenshotsInThisStep() {
        return this.screenshots == null || this.screenshots.isEmpty();
    }

    public List<Screenshot> getTopLevelScreenshots() {
        if (this.screenshots == null) {
            return new ArrayList<Screenshot>();
        }
        return this.screenshots.stream().map(screenshot -> this.renderedScreenshotOf((ScreenshotAndHtmlSource)screenshot, this.level)).collect(Collectors.toList());
    }

    public Screenshot renderedScreenshotOf(ScreenshotAndHtmlSource from, int level) {
        return new Screenshot(from.getScreenshot().getName(), this.getDescription(), TestStep.widthOf(from.getScreenshot()), from.getTimeStamp(), this.getException(), level);
    }

    private static int widthOf(File screenshot) {
        try {
            return new ResizableImage(screenshot).getWidth();
        }
        catch (IOException e) {
            return 960;
        }
    }

    private <T> T firstOf(List<T> elements) {
        return elements.get(0);
    }

    private <T> T lastOf(List<T> elements) {
        return elements.get(elements.size() - 1);
    }

    public boolean hasRestQuery() {
        return this.restQuery != null;
    }

    public boolean hasData() {
        return this.reportData != null && !this.reportData.isEmpty();
    }

    public RestQuery getRestQuery() {
        return this.restQuery;
    }

    public int getLevel() {
        return this.level;
    }

    public List<ReportData> getReportEvidence() {
        return this.getReportData().stream().filter(ReportData::isEvidence).collect(Collectors.toList());
    }

    public List<ReportData> getReportData() {
        return this.reportData == null ? new ArrayList() : this.reportData;
    }

    public ScreenshotAndHtmlSource getFirstScreenshot() {
        if (this.screenshots != null && !this.screenshots.isEmpty()) {
            return this.screenshots.get(0);
        }
        return null;
    }

    public Screenshot getEarliestScreenshot() {
        List<Screenshot> screenshots = this.getRenderedScreenshots();
        if (screenshots.isEmpty()) {
            return null;
        }
        return screenshots.get(0);
    }

    public Screenshot getLatestScreenshot() {
        List<Screenshot> screenshots = this.getRenderedScreenshots();
        if (screenshots.isEmpty()) {
            return null;
        }
        return screenshots.get(screenshots.size() - 1);
    }

    public ScreenshotAndHtmlSource getLastScreenshot() {
        if (this.screenshots != null && !this.screenshots.isEmpty()) {
            return this.screenshots.get(this.screenshots.size() - 1);
        }
        return null;
    }

    public boolean needsScreenshots() {
        return !this.isAGroup() && this.getScreenshots() != null;
    }

    public void setResult(TestResult result) {
        this.result = result;
    }

    public TestResult getResult() {
        if (this.isManual()) {
            return this.getResultFromThisStep();
        }
        if (this.isAGroup() && !this.groupResultOverridesChildren()) {
            return this.result != null ? TestResultComparison.overallResultFor(this.result, this.getResultFromChildren()) : this.getResultFromChildren();
        }
        return this.getResultFromThisStep();
    }

    public TestResult getOverallResult() {
        if (this.overallResult == null) {
            this.overallResult = this.getResult();
        }
        return this.overallResult;
    }

    private boolean isManual() {
        return this.manual != null && this.manual != false;
    }

    public TestStep asManual() {
        this.manual = true;
        return this;
    }

    private TestResult getResultFromThisStep() {
        if (this.result == null) {
            return TestResult.SUCCESS;
        }
        return this.result;
    }

    private boolean groupResultOverridesChildren() {
        return this.result == TestResult.SKIPPED || this.result == TestResult.IGNORED || this.result == TestResult.PENDING;
    }

    private TestResult getResultFromChildren() {
        return TestResultList.overallResultFrom(this.getChildResults());
    }

    private List<TestResult> getChildResults() {
        ArrayList<TestResult> childResults = new ArrayList<TestResult>();
        for (TestStep step : this.getChildren()) {
            if (step == null || step.getResult() == null) continue;
            childResults.add(step.getResult());
        }
        return childResults;
    }

    public Boolean isSuccessful() {
        return this.getResult() == TestResult.SUCCESS;
    }

    public Boolean isFailure() {
        return this.getResult() == TestResult.FAILURE;
    }

    public Boolean isError() {
        return this.getResult() == TestResult.ERROR;
    }

    public Boolean isCompromised() {
        return this.getResult() == TestResult.COMPROMISED;
    }

    public Boolean isIgnored() {
        return this.getResult() == TestResult.IGNORED;
    }

    public Boolean isSkipped() {
        return this.getResult() == TestResult.SKIPPED;
    }

    public Boolean isPending() {
        return this.getResult() == TestResult.PENDING;
    }

    public boolean isAPrecondition() {
        return this.precondition;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        return this.duration;
    }

    public double getDurationInSeconds() {
        return TestDuration.of(this.duration).inSeconds();
    }

    public String getFormattedDuration() {
        return this.duration != 0L ? CompoundDuration.of(this.duration) : "";
    }

    public void failedWith(Throwable cause) {
        this.exception = new RootCauseAnalyzer(cause).getRootCause();
        this.setResult(new FailureAnalysis().resultFor(this.exception.toException()));
    }

    public String getError() {
        return this.exception != null ? this.exception.getMessage() : "";
    }

    public String getErrorMessage() {
        if (this.exception == null) {
            return "";
        }
        return StringUtils.isEmpty((CharSequence)this.exception.getMessage()) ? this.exception.getErrorType() : this.exception.getErrorType() + ": " + this.exception.getMessage();
    }

    public String getConciseErrorMessage() {
        if (this.exception == null) {
            return "";
        }
        return StringUtils.isEmpty((CharSequence)this.exception.getMessage()) ? this.exception.getSimpleErrorType() : this.exception.getSimpleErrorType() + ": " + this.exception.getShortenedMessage();
    }

    public void testAborted(Throwable exception) {
        this.exception = new RootCauseAnalyzer(exception).getRootCause();
    }

    public String getShortErrorMessage() {
        return new ErrorMessageFormatter(this.getErrorMessage()).getShortErrorMessage();
    }

    public FailureCause getException() {
        return this.exception;
    }

    public void clearException() {
        this.exception = null;
    }

    public FailureCause getNestedException() {
        for (TestStep testStep : this.getFlattenedSteps()) {
            if (testStep.getException() == null) continue;
            return testStep.getException();
        }
        return this.getException();
    }

    public List<? extends TestStep> getFlattenedSteps() {
        ArrayList<? extends TestStep> flattenedSteps = new ArrayList<TestStep>();
        for (TestStep child : this.getChildren()) {
            flattenedSteps.add(child);
            if (!child.isAGroup()) continue;
            flattenedSteps.addAll(child.getFlattenedSteps());
        }
        flattenedSteps.sort(Comparator.comparingLong(TestStep::getNumber));
        return flattenedSteps;
    }

    private TestStep withLevel(int level) {
        this.level = level;
        return this;
    }

    public boolean isAGroup() {
        return this.hasChildren();
    }

    public boolean hasNestedErrors() {
        for (TestStep testStep : this.getFlattenedSteps()) {
            if (!testStep.isFailure().booleanValue() && !testStep.isError().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public TestStep addChildStep(TestStep step) {
        this.children.add(step.withLevel(this.level + 1));
        return this;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean hasMultipleScreenshots() {
        Set uniqueScreenshots = this.getRenderedScreenshots().stream().map(Screenshot::getFilename).collect(Collectors.toSet());
        return uniqueScreenshots.size() > 1;
    }

    public Collection<? extends TestStep> getLeafTestSteps() {
        ArrayList<? extends TestStep> leafSteps = new ArrayList<TestStep>();
        for (TestStep child : this.getChildren()) {
            if (child.isAGroup()) {
                leafSteps.addAll(child.getLeafTestSteps());
                continue;
            }
            leafSteps.add(child);
        }
        return leafSteps;
    }

    public TestStep addScreenshot(ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        if (this.thisIsANew(screenshotAndHtmlSource)) {
            this.screenshots.add(screenshotAndHtmlSource);
        }
        return this;
    }

    private boolean thisIsANew(ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        if (this.screenshots.isEmpty()) {
            return true;
        }
        ScreenshotAndHtmlSource previousScreenshot = this.screenshots.get(this.screenshots.size() - 1);
        return !screenshotAndHtmlSource.getScreenshotName().equals(previousScreenshot.getScreenshotName());
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public int getActualScreenshotCount() {
        int screenshotCount = 0;
        if (this.hasChildren()) {
            for (TestStep step : this.children) {
                screenshotCount += step.getActualScreenshotCount() + 1;
            }
            if (this.hasScreenshots()) {
                ++screenshotCount;
            }
            return screenshotCount;
        }
        return this.getScreenshotCount() - 1;
    }

    public int getScreenshotCount() {
        return this.screenshots.size();
    }

    public void removeScreenshot(int index) {
        this.screenshots.remove(index);
    }

    public TestStep withReportData(ReportData reportData) {
        if (this.reportData == null) {
            this.reportData = new ArrayList<ReportData>();
        }
        this.reportData.add(reportData);
        return this;
    }

    public TestStep recordReportData(ReportData reportData) {
        return this.withReportData(reportData);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestStep)) {
            return false;
        }
        TestStep testStep = (TestStep)o;
        if (this.duration != testStep.duration) {
            return false;
        }
        if (this.number != testStep.number) {
            return false;
        }
        if (!this.startTime.equals(testStep.startTime)) {
            return false;
        }
        if (!this.children.equals(testStep.children)) {
            return false;
        }
        if (!this.description.equals(testStep.description)) {
            return false;
        }
        if (this.result != testStep.result) {
            return false;
        }
        return !(this.screenshots == null ? testStep.screenshots != null : !this.screenshots.equals(testStep.screenshots));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.number, this.description, this.duration, this.startTime, this.screenshots, this.exception, this.result, this.restQuery, this.precondition, this.children});
    }

    public static class TestStepBuilder {
        private final String description;

        public TestStepBuilder(String description) {
            this.description = description;
        }

        public TestStep withResult(TestResult result) {
            TestStep step = new TestStep(this.description);
            step.setResult(result);
            return step;
        }
    }
}

