/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements.reports;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.serenitybdd.model.di.ModelInfrastructure;
import net.thucydides.model.domain.ReportNamer;
import net.thucydides.model.domain.ReportType;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.reports.TestOutcomes;
import net.thucydides.model.reports.html.DescriptionSplitter;
import net.thucydides.model.requirements.RequirementsService;
import net.thucydides.model.requirements.model.Requirement;
import net.thucydides.model.requirements.reports.ExampleOutcome;
import net.thucydides.model.requirements.reports.ExampleOutcomes;
import net.thucydides.model.requirements.reports.RenderMarkdown;
import net.thucydides.model.requirements.reports.ReportBadges;
import net.thucydides.model.requirements.reports.RequirementsOutcomes;
import net.thucydides.model.requirements.reports.ScenarioOutcome;
import net.thucydides.model.requirements.reports.ScenarioSummaryOutcome;
import net.thucydides.model.requirements.reports.SingleScenarioOutcome;
import net.thucydides.model.requirements.reports.cucumber.FeatureFileScenarioOutcomes;

public class ScenarioOutcomes {
    public static List<ScenarioOutcome> from(RequirementsOutcomes requirementsOutcomes) {
        if (requirementsOutcomes.getParentRequirement().isPresent() && ScenarioOutcomes.isAFeature(requirementsOutcomes.getParentRequirement().get())) {
            return ScenarioOutcomes.scenariosFrom(requirementsOutcomes.getParentRequirement().get(), requirementsOutcomes);
        }
        return requirementsOutcomes.getTestOutcomes().getOutcomes().stream().map(ScenarioOutcomes::outcomeFrom).collect(Collectors.toList());
    }

    public static List<ScenarioOutcome> from(TestOutcomes testOutcomes, RequirementsService requirements) {
        return testOutcomes.getOutcomes().stream().map(outcome -> ScenarioOutcomes.outcomeFrom(outcome, requirements)).collect(Collectors.toList());
    }

    private static boolean isAFeature(Requirement parentRequirement) {
        return parentRequirement.getFeatureFileName() != null;
    }

    private static List<ScenarioOutcome> scenariosFrom(Requirement requirement, RequirementsOutcomes requirementsOutcomes) {
        List<ScenarioOutcome> scenarioOutcomes = FeatureFileScenarioOutcomes.from(requirement).forOutcomesIn(requirementsOutcomes);
        if (scenarioOutcomes.isEmpty()) {
            scenarioOutcomes = requirementsOutcomes.getTestOutcomes().getTests().stream().map(ScenarioOutcomes::outcomeFrom).collect(Collectors.toList());
        }
        return scenarioOutcomes;
    }

    public static ScenarioOutcome outcomeFrom(TestOutcome testOutcome) {
        return ScenarioOutcomes.outcomeFrom(testOutcome, ModelInfrastructure.getRequirementsService());
    }

    public static ScenarioOutcome outcomeFrom(TestOutcome testOutcome, RequirementsService requirements) {
        String userStoryReportName;
        String userStoryName = testOutcome.getUserStory() != null ? testOutcome.getUserStory().getName() : null;
        String string = userStoryReportName = testOutcome.getUserStory() != null ? testOutcome.getUserStory().getReportName() : null;
        if (testOutcome.isDataDriven()) {
            return ScenarioOutcomes.dataDrivenOutcomeFrom(userStoryName, userStoryReportName, testOutcome, requirements);
        }
        return ScenarioOutcomes.singleScenarioOutlineFrom(userStoryName, userStoryReportName, testOutcome, requirements);
    }

    public static ScenarioOutcome singleScenarioOutlineFrom(String userStoryName, String userStoryReportName, TestOutcome testOutcome, RequirementsService requirements) {
        List<String> steps = testOutcome.getTestSteps().stream().map(step -> RenderMarkdown.convertEmbeddedTablesIn(step.getDescription())).collect(Collectors.toList());
        List<TestTag> scenarioTags = ScenarioOutcomes.getTestTags(requirements, testOutcome);
        return new SingleScenarioOutcome(testOutcome.getQualified().getTitleWithLinks(), testOutcome.getTitle(), "Scenario", testOutcome.getResult(), ReportNamer.forReportType(ReportType.HTML).getNormalizedReportNameFor(testOutcome), testOutcome.getStartTime(), testOutcome.getDuration(), testOutcome.isManual(), testOutcome.getDescription(), steps, new ArrayList<String>(), testOutcome.getDataTableRowCount(), userStoryName, userStoryReportName, testOutcome.getTags(), testOutcome.getRule(), testOutcome.getExternalLink(), scenarioTags, testOutcome.getContext());
    }

    private static List<TestTag> getTestTags(RequirementsService requirements, TestOutcome testOutcome) {
        Optional<Requirement> requirement = requirements.getParentRequirementFor(testOutcome);
        ArrayList<TestTag> scenarioTags = new ArrayList<TestTag>();
        if (requirement.isPresent() && requirement.get().getScenarioTags() != null && requirement.get().getScenarioTags().get(testOutcome.getName()) != null) {
            scenarioTags.addAll(requirement.get().getScenarioTags().get(testOutcome.getName()));
        }
        return scenarioTags;
    }

    public static ScenarioOutcome dataDrivenOutcomeFrom(String userStoryName, String userStoryReportName, TestOutcome testOutcome, RequirementsService requirements) {
        List<String> steps = testOutcome.getDataDrivenSampleScenario() != null && !testOutcome.getDataDrivenSampleScenario().isEmpty() ? ScenarioOutcomes.testStepsFromSampleScenario(testOutcome.getDataDrivenSampleScenario()) : testOutcome.getTestSteps().stream().map(step -> RenderMarkdown.convertEmbeddedTablesIn(step.getDescription())).collect(Collectors.toList());
        List<TestTag> scenarioTags = ScenarioOutcomes.getTestTags(requirements, testOutcome);
        List<String> reportBadges = ReportBadges.from(Collections.singletonList(testOutcome), testOutcome.getTitle());
        List<ExampleOutcome> exampleOutcomes = ExampleOutcomes.from(testOutcome);
        return new ScenarioSummaryOutcome(testOutcome.getQualified().getTitleWithLinks(), "Scenario Outline", testOutcome.getResult(), reportBadges, ReportNamer.forReportType(ReportType.HTML).getNormalizedReportNameFor(testOutcome), testOutcome.getDescription(), steps, Collections.EMPTY_LIST, exampleOutcomes, exampleOutcomes.size(), testOutcome.isManual(), userStoryName, userStoryReportName, testOutcome.getTags(), new HashMap<String, Collection<TestTag>>(), testOutcome.getRule(), testOutcome.getStartTime(), testOutcome.getDuration(), scenarioTags, testOutcome.getContext());
    }

    private static List<String> testStepsFromSampleScenario(String sampleDataDrivenScenario) {
        return DescriptionSplitter.splitIntoSteps(sampleDataDrivenScenario).stream().map(RenderMarkdown::convertEmbeddedTablesIn).collect(Collectors.toList());
    }
}

