/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements.reports;

import net.thucydides.model.domain.TestResult;
import net.thucydides.model.reports.TestOutcomes;
import net.thucydides.model.requirements.model.Requirement;
import net.thucydides.model.requirements.reports.RequirmentCalculator;

public class ChildRequirementCounter
implements RequirmentCalculator {
    private final Requirement requirement;
    private final TestOutcomes testOutcomes;

    public ChildRequirementCounter(Requirement requirement, TestOutcomes testOutcomes) {
        this.requirement = requirement;
        this.testOutcomes = testOutcomes;
    }

    @Override
    public long countAllSubrequirements() {
        return this.requirement.getChildren().size();
    }

    @Override
    public long countSubrequirementsWithResult(TestResult expectedResult) {
        return this.requirement.getChildren().stream().filter(req -> this.testResultFor((Requirement)req) == expectedResult).count();
    }

    @Override
    public long countSubrequirementsWithNoTests() {
        return this.requirement.getChildren().stream().filter(req -> this.testOutcomes.forRequirement((Requirement)req).getOutcomes().isEmpty()).count();
    }

    private TestResult testResultFor(Requirement req) {
        if (this.testOutcomes.forRequirement(req).getOutcomes().isEmpty()) {
            return TestResult.UNDEFINED;
        }
        return this.testOutcomes.forRequirement(req).getResult();
    }
}

