/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class SearchForFilesOfType
extends SimpleFileVisitor<Path> {
    private final String suffix;
    Path root;
    List<Path> matchingFiles;
    int maxDepth;

    public SearchForFilesOfType(Path root, String suffix) {
        this.suffix = suffix;
        this.root = root;
        this.matchingFiles = new ArrayList<Path>();
        this.maxDepth = 0;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
        if (file.getFileName().toString().endsWith(this.suffix)) {
            this.matchingFiles.add(file);
            int depth = file.getNameCount() - this.root.getNameCount() - 1;
            if (depth > this.maxDepth) {
                this.maxDepth = depth;
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        return FileVisitResult.CONTINUE;
    }

    public List<Path> getMatchingFiles() {
        return this.matchingFiles;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public boolean hasMatchingFiles() {
        return !this.matchingFiles.isEmpty();
    }
}

