/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.environment;

import com.typesafe.config.Config;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import net.serenitybdd.model.environment.ConfiguredEnvironment;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class MockEnvironmentVariables
implements EnvironmentVariables {
    private Map<String, String> properties = new HashMap<String, String>();
    private Map<String, String> values = new HashMap<String, String>();

    public MockEnvironmentVariables() {
        this.properties.put("user.home", System.getProperty("user.home"));
        this.properties.put("feature.file.encoding", "UTF-8");
        if (this.localEnvironment().getProperty("phantomjs.binary.path") != null) {
            this.properties.put("phantomjs.binary.path", this.localEnvironment().getProperty("phantomjs.binary.path"));
        }
        if (this.localEnvironment().getProperty("webdriver.chrome.driver") != null) {
            this.properties.put("webdriver.chrome.driver", this.localEnvironment().getProperty("webdriver.chrome.driver"));
        }
    }

    private EnvironmentVariables localEnvironment() {
        return ConfiguredEnvironment.getEnvironmentVariables();
    }

    protected MockEnvironmentVariables(Map<String, String> properties) {
        this.properties = new HashMap<String, String>(properties);
    }

    protected MockEnvironmentVariables(Map<String, String> properties, Map<String, String> values) {
        this.properties = new HashMap<String, String>(properties);
        this.values = new HashMap<String, String>(values);
    }

    public static EnvironmentVariables fromSystemEnvironment() {
        return new MockEnvironmentVariables(SystemEnvironmentVariables.createEnvironmentVariables().properties());
    }

    public boolean propertySetIsEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public String getValue(String name) {
        return this.values.get(name);
    }

    @Override
    public String getValue(Enum<?> property) {
        return this.getValue(property.toString());
    }

    @Override
    public String getValue(String name, String defaultValue) {
        return this.values.get(name) == null ? defaultValue : this.values.get(name);
    }

    @Override
    public String getValue(Enum<?> property, String defaultValue) {
        return this.getValue(property.toString(), defaultValue);
    }

    @Override
    public Integer getPropertyAsInteger(String name, Integer defaultValue) {
        String value = this.properties.get(name);
        if (StringUtils.isNumeric((CharSequence)value)) {
            return Integer.parseInt(this.properties.get(name));
        }
        return defaultValue;
    }

    @Override
    public Integer getPropertyAsInteger(Enum<?> property, Integer defaultValue) {
        return this.getPropertyAsInteger(property.toString(), defaultValue);
    }

    @Override
    public Boolean getPropertyAsBoolean(String name, boolean defaultValue) {
        if (this.properties.get(name) == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(this.properties.get(name));
    }

    @Override
    public Boolean getPropertyAsBoolean(Enum<?> property, boolean defaultValue) {
        return this.getPropertyAsBoolean(property.toString(), defaultValue);
    }

    @Override
    public String getProperty(String name) {
        if (name != null) {
            return this.properties.get(name);
        }
        return null;
    }

    @Override
    public Optional<String> optionalProperty(String name) {
        return Optional.ofNullable(this.getProperty(name));
    }

    @Override
    public String getProperty(Enum<?> property) {
        return this.getProperty(property.toString());
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        return this.properties.get(name) == null ? defaultValue : this.properties.get(name);
    }

    @Override
    public String getProperty(Enum<?> property, String defaultValue) {
        return this.getProperty(property.toString(), defaultValue);
    }

    @Override
    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    @Override
    public void setProperties(Map<String, String> newProperties) {
        this.properties.putAll(newProperties);
    }

    @Override
    public void clearProperty(String name) {
        this.properties.remove(name);
    }

    @Override
    public EnvironmentVariables copy() {
        return new MockEnvironmentVariables(this.properties, this.values);
    }

    @Override
    public List<String> getKeys() {
        return this.properties.keySet().stream().map(Object::toString).collect(Collectors.toList());
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll(this.properties);
        return props;
    }

    @Override
    public Properties getPropertiesWithPrefix(String prefix) {
        return new SystemEnvironmentVariables(this.properties, this.values).getPropertiesWithPrefix(prefix);
    }

    @Override
    public boolean aValueIsDefinedFor(Enum<?> property) {
        return this.properties.containsKey(property.toString());
    }

    @Override
    public boolean aValueIsDefinedFor(String property) {
        return this.properties.containsKey(property);
    }

    @Override
    public boolean hasPath(String path) {
        return false;
    }

    @Override
    public String injectSystemPropertiesInto(String value) {
        return value;
    }

    @Override
    public Map<String, String> asMap() {
        HashMap<String, String> environmentValues = new HashMap<String, String>();
        this.values.keySet().forEach(key -> environmentValues.put((String)key, this.values.get(key)));
        this.properties.keySet().forEach(key -> environmentValues.put((String)key, this.properties.get(key)));
        return environmentValues;
    }

    @Override
    public Map<String, String> simpleSystemPropertiesAsMap() {
        return new HashMap<String, String>();
    }

    @Override
    public void reset() {
    }

    @Override
    public void setConfig(Config typesafeConfig) {
    }

    @Override
    public Config getConfig(String prefix) {
        return EnvironmentVariables.super.getConfig(prefix);
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    public void setValue(String name, String value) {
        this.values.put(name, value);
    }
}

