/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.domain;

import io.cucumber.messages.types.Background;
import java.util.List;
import java.util.stream.Collectors;
import net.thucydides.model.requirements.reports.cucumber.RenderCucumber;

public class RuleBackground {
    private final String name;
    private final String description;
    private final List<String> steps;

    public RuleBackground(String name, String description, List<String> steps) {
        this.name = name;
        this.description = description;
        this.steps = steps;
    }

    public static RuleBackground from(Background background) {
        String name = background.getName();
        String description = background.getDescription();
        List<String> steps = background.getSteps().stream().map(RenderCucumber::step).collect(Collectors.toList());
        return new RuleBackground(name, description, steps);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getSteps() {
        return this.steps;
    }
}

