/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.model.rest;

import java.util.Optional;

public enum RestMethod {
    PUT,
    GET,
    POST,
    PATCH,
    OPTIONS,
    HEAD,
    DELETE;

    private static final Optional<RestMethod> NOT_A_REST_METHOD;

    public static Optional<RestMethod> restMethodCalled(String value) {
        return RestMethod.isRestMethod(value) ? Optional.ofNullable(RestMethod.valueOf(value.toUpperCase())) : NOT_A_REST_METHOD;
    }

    private static boolean isRestMethod(String value) {
        for (RestMethod restMethod : RestMethod.values()) {
            if (!value.equalsIgnoreCase(restMethod.name())) continue;
            return true;
        }
        return false;
    }

    static {
        NOT_A_REST_METHOD = Optional.empty();
    }
}

