/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fields {
    private static final Logger LOGGER = LoggerFactory.getLogger(Fields.class);
    private final Class<?> clazz;

    public static Fields of(Class<?> testClass) {
        return new Fields(testClass);
    }

    private Fields(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Set<Field> allFields() {
        HashSet<Field> fields = new HashSet<Field>();
        fields.addAll(Arrays.asList(this.clazz.getDeclaredFields()));
        fields.addAll(Arrays.asList(this.clazz.getFields()));
        if (this.clazz != Object.class) {
            fields.addAll(Fields.of(this.clazz.getSuperclass()).allFields());
        }
        return fields;
    }

    public Set<Field> declaredFields() {
        HashSet<Field> fields = new HashSet<Field>();
        fields.addAll(Arrays.asList(this.clazz.getDeclaredFields()));
        return fields;
    }

    public Set<Field> nonStaticFields() {
        Set<Field> fields = this.allFields();
        HashSet<Field> nonStaticFields = new HashSet<Field>();
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            nonStaticFields.add(field);
        }
        return nonStaticFields;
    }

    public Optional<Field> withName(String pages) {
        return this.allFields().stream().filter(field -> field.getName().equals(pages)).findFirst();
    }

    public List<Field> fieldsAnnotatedBy(Class<? extends Annotation> annotationClass) {
        return this.allFields().stream().filter(field -> field.getAnnotation(annotationClass) != null).collect(Collectors.toList());
    }

    public static FieldValueBuilder of(Object object) {
        return new FieldValueBuilder(object);
    }

    public static boolean isAbstract(Field field) {
        return Modifier.isAbstract(field.getType().getModifiers());
    }

    public static boolean isFinal(Field field) {
        return Modifier.isFinal(field.getType().getModifiers());
    }

    public static boolean isStatic(Field field) {
        return Modifier.isStatic(field.getType().getModifiers());
    }

    public static class FieldValueBuilder {
        private final Object object;

        FieldValueBuilder(Object object) {
            this.object = object;
        }

        public Map<String, Object> asMap() {
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            for (Field field : Fields.of(this.object.getClass()).allFields()) {
                try {
                    field.setAccessible(true);
                    if (!this.isValid(field)) continue;
                    fieldValues.put(field.getName(), this.fieldValueFrom(field).or(FieldValue.UNDEFINED));
                }
                catch (IllegalAccessException e) {
                    LOGGER.warn("Failed to inject the field " + field.getName(), (Throwable)e);
                }
            }
            fieldValues.put("self", this.object);
            fieldValues.put("this", this.object);
            return fieldValues;
        }

        private boolean isValid(Field field) {
            return field != null && !field.getName().contains("CGLIB");
        }

        private FieldValueProvider fieldValueFrom(Field field) {
            return new FieldValueProvider(field, this.object);
        }

        private static class FieldValueProvider {
            Field field;
            Object object;

            FieldValueProvider(Field field, Object object) {
                this.field = field;
                this.object = object;
            }

            public Object or(FieldValue undefinedValue) throws IllegalAccessException {
                return this.field == null || this.object == null || this.field.get(this.object) == null ? undefinedValue : this.field.get(this.object);
            }
        }
    }

    public static enum FieldValue {
        UNDEFINED;

    }
}

