/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import java.util.List;
import net.serenitybdd.core.di.ModelInfrastructure;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.requirements.Requirements;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.reports.MultipleSourceRequirmentsOutcomeFactory;
import net.thucydides.core.requirements.reports.RequirementsOutcomeFactory;

public class DefaultRequirements
implements Requirements {
    private final RequirementsService requirementsService;
    private final RequirementsOutcomeFactory requirmentsOutcomeFactory;

    public DefaultRequirements(String testRootPackage) {
        if (testRootPackage != null) {
            ConfiguredEnvironment.getEnvironmentVariables().setProperty("serenity.test.root", testRootPackage);
        }
        this.requirementsService = ModelInfrastructure.getRequirementsService();
        this.requirmentsOutcomeFactory = new MultipleSourceRequirmentsOutcomeFactory(ModelInfrastructure.getRequirementsProviderService().getRequirementsProviders(), ModelInfrastructure.getIssueTracking(), new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.getRequirementsService()));
    }

    public DefaultRequirements() {
        this.requirementsService = ModelInfrastructure.getRequirementsService();
        this.requirmentsOutcomeFactory = new MultipleSourceRequirmentsOutcomeFactory(ModelInfrastructure.getRequirementsProviderService().getRequirementsProviders(), ModelInfrastructure.getIssueTracking(), new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.getRequirementsService()));
    }

    public DefaultRequirements(ReportNameProvider reportNameProvider) {
        this.requirementsService = ModelInfrastructure.getRequirementsService();
        this.requirmentsOutcomeFactory = new MultipleSourceRequirmentsOutcomeFactory(ModelInfrastructure.getRequirementsProviderService().getRequirementsProviders(), ModelInfrastructure.getIssueTracking(), reportNameProvider);
    }

    @Override
    public RequirementsService getRequirementsService() {
        return this.requirementsService;
    }

    @Override
    public RequirementsOutcomeFactory getRequirementsOutcomeFactory() {
        return this.requirmentsOutcomeFactory;
    }

    @Override
    public List<String> getTypes() {
        return this.requirementsService.getRequirementTypes();
    }
}

