/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports.cucumber;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.File;
import java.util.Optional;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.requirements.model.cucumber.AnnotatedFeature;
import net.thucydides.core.requirements.model.cucumber.CucumberParser;
import net.thucydides.core.util.EnvironmentVariables;

public class FeatureCache {
    private static final FeatureCache FEATURE_CACHE = new FeatureCache();
    private final CucumberParser parser;
    LoadingCache<String, Optional> cache;

    public static FeatureCache getCache() {
        return FEATURE_CACHE;
    }

    protected FeatureCache() {
        EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
        int maxHeap = ThucydidesSystemProperty.SERENITY_REQUIREMENTS_CACHE_HEAP_SIZE.integerFrom(environmentVariables, 1024);
        this.cache = Caffeine.newBuilder().maximumSize((long)maxHeap).build(this::loadFeatureFileFrom);
        this.parser = new CucumberParser();
    }

    public Optional<AnnotatedFeature> loadFeature(File featureFile) {
        return this.loadFeature(featureFile.getPath());
    }

    public Optional<AnnotatedFeature> loadFeature(String featureFilePath) {
        return (Optional)this.cache.get((Object)featureFilePath);
    }

    private Optional<AnnotatedFeature> loadFeatureFileFrom(String featureFilePath) {
        return this.parser.loadFeature(new File(featureFilePath));
    }

    public void close() {
        this.cache.invalidateAll();
    }
}

