/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.google.common.base.Splitter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.PathElement;
import net.thucydides.core.model.PathElements;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.TestOutcomeLoader;
import net.thucydides.core.requirements.OverridableTagProvider;
import net.thucydides.core.requirements.RequirementTypesProvider;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.model.RequirementsConfiguration;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;

public class TestOutcomeRequirementsTagProvider
implements RequirementsTagProvider,
OverridableTagProvider,
RequirementTypesProvider {
    private final RequirementsConfiguration requirementsConfiguration;
    private EnvironmentVariables environmentVariables;
    private List<Requirement> requirements;
    private List<Requirement> flattenedRequirements;
    private static final List<String> SUPPORTED_TEST_SOURCES = NewList.of("JUnit", "JUnit5");

    public TestOutcomeRequirementsTagProvider() {
        this((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public TestOutcomeRequirementsTagProvider(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.requirementsConfiguration = new RequirementsConfiguration(environmentVariables);
    }

    @Override
    public List<String> getActiveRequirementTypes() {
        HashMap requirementsDepth = new HashMap();
        this.getFlattenedRequirements().forEach(requirement -> {
            if (requirementsDepth.getOrDefault(requirement.getType(), 0) < requirement.getDepth()) {
                requirementsDepth.put(requirement.getType(), requirement.getDepth());
            }
        });
        return requirementsDepth.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Requirement> getRequirements() {
        if (this.requirements == null) {
            TestOutcomeRequirementsTagProvider testOutcomeRequirementsTagProvider = this;
            synchronized (testOutcomeRequirementsTagProvider) {
                this.requirements = this.loadRequirements();
            }
        }
        return this.requirements;
    }

    private Stream<TestOutcome> supportedOutcomesFrom(List<TestOutcome> outcomes) {
        return outcomes.stream().filter(outcome -> SUPPORTED_TEST_SOURCES.contains(outcome.getTestSource()));
    }

    private List<Requirement> loadRequirements() {
        TestOutcomeLoader loader = new TestOutcomeLoader();
        File outputDirectory = new File(ThucydidesSystemProperty.SERENITY_OUTPUT_DIRECTORY.from(this.environmentVariables, "target/site/serenity"));
        List<TestOutcome> outcomes = loader.loadFrom(outputDirectory);
        int maxRequirementsDepth = this.supportedOutcomesFrom(outcomes).filter(outcome -> !outcome.getUserStory().getPathElements().isEmpty()).mapToInt(outcome -> outcome.getUserStory().getPathElements().size()).max().orElse(0);
        List<Requirement> leafLevelRequirements = this.supportedOutcomesFrom(outcomes).map(TestOutcome::getUserStory).distinct().map(this::requirementFrom).collect(Collectors.toList());
        Map<PathElements, Requirement> nonLeafRequirements = this.supportedOutcomesFrom(outcomes).map(outcome -> outcome.getUserStory().getPathElements()).filter(pathElements -> !pathElements.isEmpty()).distinct().map(pathElements -> this.relativePathFrom((PathElements)pathElements)).filter(pathElements -> !pathElements.isEmpty()).collect(Collectors.toMap(pathElements -> pathElements, pathElements -> this.nonLeafRequirementFrom((PathElements)pathElements, maxRequirementsDepth)));
        nonLeafRequirements.forEach((path, requirement) -> {
            Requirement parentRequirement;
            PathElements parentPath = path.getParent();
            if (parentPath != null && (parentRequirement = (Requirement)nonLeafRequirements.get(parentPath)) != null) {
                requirement.setParent(parentRequirement.getPath());
            }
        });
        leafLevelRequirements.forEach(requirement -> {
            Requirement parentRequirement;
            PathElements parentPath = requirement.getPathElements(this.environmentVariables);
            if (parentPath != null && !parentPath.isEmpty() && (parentRequirement = (Requirement)nonLeafRequirements.get(parentPath)) != null) {
                requirement.setParent(parentRequirement.getPath());
            }
        });
        nonLeafRequirements.forEach((path, requirement) -> {
            List<Requirement> childRequirements = leafLevelRequirements.stream().filter(childRequirement -> childRequirement.hasParent((PathElements)path)).collect(Collectors.toList());
            List nonLeafChildRequirements = nonLeafRequirements.values().stream().filter(childRequirement -> childRequirement.hasParent((PathElements)path)).collect(Collectors.toList());
            childRequirements.addAll(nonLeafChildRequirements);
            requirement.setChildren(childRequirements);
        });
        ArrayList<Requirement> allRequirements = new ArrayList<Requirement>();
        allRequirements.addAll(nonLeafRequirements.values());
        allRequirements.addAll(leafLevelRequirements);
        return allRequirements.stream().filter(requirement -> requirement.getParent() == null).collect(Collectors.toList());
    }

    private Requirement nonLeafRequirementFrom(PathElements relativePath, int maxRequirementsDepth) {
        PathElement requirementLeaf = (PathElement)relativePath.get(relativePath.size() - 1);
        String path = relativePath.stream().map(PathElement::getName).collect(Collectors.joining("/"));
        String requirementType = this.requirementsConfiguration.getRequirementType(relativePath.size() - 1, maxRequirementsDepth);
        String requirementName = Inflector.inflection().humanize(requirementLeaf.getName(), new String[0]);
        return Requirement.named(requirementName).withType(requirementType).withNarrative(requirementLeaf.getDescription()).withPath(path);
    }

    private PathElements relativePathFrom(PathElements pathElements) {
        String rootPackage = ThucydidesSystemProperty.SERENITY_TEST_ROOT.from(this.environmentVariables, "");
        List rootPackageElements = Splitter.on((String)".").omitEmptyStrings().splitToList((CharSequence)rootPackage);
        ArrayList<PathElement> relativePathElements = new ArrayList<PathElement>(pathElements);
        for (String rootPackageElement : rootPackageElements) {
            if (!((PathElement)relativePathElements.get(0)).getName().equals(rootPackageElement)) continue;
            relativePathElements.remove(0);
        }
        return PathElements.from(relativePathElements);
    }

    private Requirement requirementFrom(Story userStory) {
        return Requirement.named(userStory.getName()).withType(userStory.getType()).withNarrative(userStory.getNarrative()).withPath(userStory.getPath());
    }

    @Override
    public Optional<Requirement> getParentRequirementOf(TestOutcome testOutcome) {
        if (testOutcome.getUserStory() == null || testOutcome.getUserStory().getPath() == null) {
            return Optional.empty();
        }
        String testOutcomePath = testOutcome.getUserStory().getPath();
        String normalizedPath = testOutcomePath.replace(".", "/");
        return this.getFlattenedRequirements().stream().filter(requirement -> testOutcomePath.equals(requirement.getPath()) || normalizedPath.equals(requirement.getPath())).findFirst();
    }

    @Override
    public Optional<Requirement> getParentRequirementOf(Requirement requirement) {
        return this.getFlattenedRequirements().stream().filter(parentRequirement -> requirement.hasParent(parentRequirement.getPath())).findFirst();
    }

    @Override
    public Optional<Requirement> getRequirementFor(TestTag testTag) {
        Optional<Requirement> result = Optional.empty();
        for (Requirement requirement : this.getFlattenedRequirements()) {
            if (!requirement.matchesTag(testTag)) continue;
            return Optional.of(requirement);
        }
        return result;
    }

    @Override
    public Set<TestTag> getTagsFor(TestOutcome testOutcome) {
        HashSet<TestTag> result = new HashSet<TestTag>();
        Optional<Requirement> parentRequirement = this.getParentRequirementOf(testOutcome);
        if (parentRequirement.isPresent()) {
            result.add(parentRequirement.get().asTag());
            Optional<Requirement> parent = this.getParentRequirementOf(parentRequirement.get());
            while (parent.isPresent()) {
                result.add(parent.get().asTag());
                parent = this.getParentRequirementOf(parent.get());
            }
        }
        return result;
    }

    private boolean isMatchingRequirementFor(TestOutcome testOutcome, Requirement requirement) {
        String testOutcomePath = testOutcome.getUserStory().getPath();
        return requirement.matchesTag(testOutcome.getUserStory().asTag()) || requirement.matchesOrIsAParentOf(testOutcomePath);
    }

    public List<Requirement> getFlattenedRequirements() {
        return this.getFlattenedRequirements(this.getRequirements());
    }

    private List<Requirement> getFlattenedRequirements(List<Requirement> requirements) {
        if (this.flattenedRequirements == null) {
            ArrayList<Requirement> flattenedRequirements = new ArrayList<Requirement>();
            for (Requirement requirement : requirements) {
                flattenedRequirements.add(requirement);
                if (requirement.getChildren() == null || requirement.getChildren().isEmpty()) continue;
                flattenedRequirements.addAll(this.getFlattenedRequirements(requirement.getChildren()));
            }
            this.flattenedRequirements = flattenedRequirements;
        }
        return this.flattenedRequirements;
    }
}

