/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.base.Splitter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.serenitybdd.core.strings.FirstLine;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.AnnotatedDescription;
import net.thucydides.core.annotations.Feature;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.AnnotatedStoryTitle;
import net.thucydides.core.model.LastElement;
import net.thucydides.core.model.PathElement;
import net.thucydides.core.model.PathElements;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.Stories;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.features.ApplicationFeature;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.requirements.RootDirectory;
import net.thucydides.core.requirements.model.FeatureType;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;

public class Story {
    private String id;
    private String storyName;
    private String displayName;
    private String storyClassName;
    private String path;
    private PathElements pathElements;
    private String narrative;
    private ApplicationFeature feature;
    private String type;
    private TestTag qualifiedTag;
    private TestTag singleParentTag;
    private static String FEATURE_FILES_DIRECTORY = "src/test/resources/.*/";
    private static final Pattern FEATURE_FILES_DIRECTORY_PATTERN = Pattern.compile(FEATURE_FILES_DIRECTORY);

    protected Story(Class<?> userStoryClass) {
        this.id = userStoryClass.getCanonicalName();
        this.storyClassName = userStoryClass.getName();
        this.storyName = NameConverter.humanize(userStoryClass.getSimpleName());
        this.displayName = AnnotatedStoryTitle.forClass(userStoryClass).orElse(NameConverter.humanize(userStoryClass.getSimpleName()));
        this.feature = this.findFeatureFrom(userStoryClass);
        this.path = Story.pathOf(userStoryClass);
        this.narrative = AnnotatedDescription.forClass(userStoryClass).orElse("");
        this.pathElements = this.pathElementsFromPackagePath(this.path);
        this.type = FeatureType.STORY.toString();
    }

    private PathElements pathElementsFromPackagePath(String path) {
        EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
        String rootPath = ThucydidesSystemProperty.SERENITY_TEST_ROOT.from(environmentVariables, "");
        if (StringUtils.isNotEmpty((CharSequence)rootPath) && path.startsWith(rootPath)) {
            String string = path = path.equals(rootPath) ? "" : path.substring(rootPath.length() + 1);
        }
        if (path == null) {
            return PathElements.from(new ArrayList<PathElement>());
        }
        return PathElements.from(Splitter.on((String)".").trimResults().splitToStream((CharSequence)path).map(pathElt -> new PathElement((String)pathElt, "")).collect(Collectors.toList()));
    }

    private PathElements pathElementsFromDirectoryPath(String path) {
        ArrayList<PathElement> pathElements = new ArrayList<PathElement>();
        if (path != null) {
            Path storyPath = Paths.get(path, new String[0]);
            for (int i = 0; i < storyPath.getNameCount(); ++i) {
                pathElements.add(new PathElement(storyPath.getName(i).toString(), ""));
            }
        }
        return PathElements.from(pathElements);
    }

    public static String pathOf(Class<?> userStoryClass) {
        String canonicalName = userStoryClass.getCanonicalName();
        String localPath = Story.stripRootPathFrom(canonicalName);
        int lastDot = localPath.lastIndexOf(".");
        if (lastDot > 0) {
            return localPath.substring(0, lastDot);
        }
        return "";
    }

    private static String stripRootPathFrom(String testOutcomePath) {
        EnvironmentVariables environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
        if (testOutcomePath == null) {
            return "";
        }
        String rootPath = ThucydidesSystemProperty.SERENITY_TEST_ROOT.from(environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)rootPath) && testOutcomePath.startsWith(rootPath) && !testOutcomePath.equals(rootPath)) {
            return testOutcomePath.substring(rootPath.length() + 1);
        }
        return testOutcomePath;
    }

    private ApplicationFeature findFeatureFrom(Class<?> userStoryClass) {
        if (Story.getFeatureClass(userStoryClass) != null) {
            return ApplicationFeature.from(Story.getFeatureClass(userStoryClass));
        }
        return null;
    }

    public Story(String id, String storyName, String storyClassName, String displayName, String path, ApplicationFeature feature) {
        this.id = id;
        this.storyName = storyName;
        this.storyClassName = storyClassName;
        this.displayName = displayName;
        this.feature = feature;
        this.path = this.normalisedPath(path);
        this.pathElements = this.pathElementsFromDirectoryPath(this.path);
        this.narrative = null;
        this.type = FeatureType.STORY.toString();
    }

    public Story(String id, String storyName, String storyClassName, String displayName, String path, PathElements pathElements, ApplicationFeature feature, String narrative) {
        this(id, storyName, storyClassName, displayName, path, pathElements, feature, narrative, FeatureType.STORY.toString());
    }

    public Story(String id, String storyName, String storyClassName, String displayName, String path, PathElements pathElements, ApplicationFeature feature, String narrative, String type) {
        this.id = id;
        this.storyName = storyName;
        this.storyClassName = storyClassName;
        this.displayName = displayName;
        this.feature = feature;
        this.path = path;
        this.pathElements = pathElements;
        this.narrative = narrative;
        this.type = type;
    }

    protected Story(String id, String storyName, String displayName, ApplicationFeature feature, String path) {
        this.id = id;
        this.storyName = storyName;
        this.displayName = displayName;
        this.storyClassName = null;
        this.feature = feature;
        this.path = this.normalisedPath(path);
        this.pathElements = this.pathElementsFromDirectoryPath(this.path);
        this.type = path != null && path.endsWith(".feature") ? FeatureType.FEATURE.toString() : FeatureType.STORY.toString();
    }

    public String getId() {
        return this.id;
    }

    public static Story from(Class<?> userStoryClass) {
        return new Story(userStoryClass);
    }

    public static Story withId(String storyId, String storyName) {
        return new Story(storyId, storyName, null, null, null);
    }

    public Story withNarrative(String narrative) {
        return new Story(this.id, this.storyName, this.storyClassName, this.displayName, this.path, this.pathElements, this.feature, narrative, this.type);
    }

    public Story withType(String type) {
        return new Story(this.id, this.storyName, this.storyClassName, this.displayName, this.path, this.pathElements, this.feature, this.narrative, type);
    }

    public static Story withIdAndPath(String storyId, String storyName, String storyPath) {
        return new Story(storyId, storyName, null, storyName, storyPath, null);
    }

    public Story withDisplayName(String name) {
        this.displayName = name;
        return this;
    }

    public Story withStoryName(String name) {
        this.storyName = name;
        return this;
    }

    public static Story called(String storyName) {
        return new Story(storyName, storyName, null, null, null);
    }

    public static Story withId(String storyId, String storyName, String featureClassName, String featureName) {
        return new Story(storyId, storyName, storyName, new ApplicationFeature(featureClassName, featureName), null);
    }

    public static Story withIdAndPathAndFeature(String storyId, String storyName, String storyPath, String featureClassName, String featureName) {
        return new Story(storyId, storyName, storyName, new ApplicationFeature(featureClassName, featureName), storyPath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Story)) {
            return false;
        }
        Story story = (Story)o;
        if (!this.id.equals(story.id)) {
            return false;
        }
        return Objects.equals(this.path, story.path);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        return result;
    }

    public static Class<?> getFeatureClass(Class<?> userStoryClass) {
        Class<?> enclosingClass;
        if (userStoryClass != null && Story.isAFeature(enclosingClass = userStoryClass.getEnclosingClass())) {
            return enclosingClass;
        }
        return null;
    }

    private static boolean isAFeature(Class<?> enclosingClass) {
        return enclosingClass != null && enclosingClass.getAnnotation(Feature.class) != null;
    }

    public static Class<?> testedInTestCase(Class<?> testClass) {
        net.thucydides.core.annotations.Story story = testClass.getAnnotation(net.thucydides.core.annotations.Story.class);
        if (story != null) {
            return story.value();
        }
        return null;
    }

    public String getName() {
        return this.storyName;
    }

    public String getDisplayName() {
        return StringUtils.isNotEmpty((CharSequence)this.displayName) ? this.displayName : this.storyName;
    }

    public String getStoryClassName() {
        return this.storyClassName;
    }

    public String getReportName(ReportType type) {
        return Stories.reportFor(this, type);
    }

    public String getReportName() {
        return new ReportNameProvider().forRequirement(this.asTag());
    }

    public ApplicationFeature getFeature() {
        return this.feature;
    }

    public String getPath() {
        return this.path;
    }

    public PathElements getPathElements() {
        return this.pathElements;
    }

    public String getStoryName() {
        return this.storyName;
    }

    public String getNarrative() {
        return this.narrative;
    }

    public String getNarrativeSummary() {
        return FirstLine.of(this.narrative);
    }

    public String getType() {
        return this.type;
    }

    public Story withPath(String path) {
        this.path = path;
        this.type = FeatureType.forFilename(path).toString();
        return this;
    }

    public Story asFeature() {
        this.type = FeatureType.FEATURE.toString();
        return this;
    }

    public TestTag asTag() {
        return this.asQualifiedTag();
    }

    public TestTag asQualifiedTag() {
        if (this.qualifiedTag == null) {
            String parentName;
            EnvironmentVariables environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
            String featureDirectoryName = RootDirectory.definedIn(environmentVariables).featureDirectoryName();
            String lastElementOfPath = LastElement.of(this.getPath());
            String string = parentName = this.getPath() != null ? NameConverter.humanize(lastElementOfPath) : null;
            if (featureDirectoryName.equalsIgnoreCase(lastElementOfPath)) {
                parentName = null;
            }
            this.qualifiedTag = StringUtils.isNotEmpty((CharSequence)parentName) ? TestTag.withName(parentName + "/" + this.storyName).andType(this.type) : TestTag.withName(this.storyName).andType(this.type);
        }
        return this.qualifiedTag;
    }

    public TestTag asSingleParentTag() {
        if (this.singleParentTag == null) {
            String lastElementOfPath = this.getPathElements() == null || this.getPathElements().isEmpty() ? "" : ((PathElement)this.getPathElements().get(this.getPathElements().size() - 1)).getName();
            this.singleParentTag = StringUtils.isNotEmpty((CharSequence)lastElementOfPath) ? TestTag.withName(lastElementOfPath + "/" + this.storyName).andType(this.type) : TestTag.withName(this.storyName).andType(this.type);
        }
        return this.singleParentTag;
    }

    private String normalisedPath(String path) {
        if (path == null) {
            return path;
        }
        String normalisedPath = path;
        if (normalisedPath.startsWith("classpath:features/")) {
            normalisedPath = normalisedPath.substring("classpath:features/".length());
        }
        if (normalisedPath.endsWith(".feature") || normalisedPath.endsWith(".story")) {
            normalisedPath = this.relativeFeaturePath(normalisedPath);
        }
        return normalisedPath;
    }

    private String relativeFeaturePath(String path) {
        String normalisedPath = path;
        Matcher matcher = FEATURE_FILES_DIRECTORY_PATTERN.matcher(path);
        if (matcher.find()) {
            normalisedPath = path.substring(matcher.end());
        }
        if (normalisedPath.endsWith(".feature") || normalisedPath.endsWith(".story")) {
            Path featureFilePath = Paths.get(normalisedPath, new String[0]);
            Path parentPath = featureFilePath.getParent();
            normalisedPath = parentPath != null ? parentPath.toString() : "";
        }
        return normalisedPath;
    }
}

