/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.thucydides.core.guice.ThucydidesModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Injectors {
    private static final Logger LOGGER = LoggerFactory.getLogger(Injectors.class);
    private static final Map<String, Injector> injectors = Collections.synchronizedMap(new HashMap());
    private static Module defaultModule;

    public static synchronized void setDefaultModule(Module module) {
        defaultModule = module;
        LOGGER.trace("Set default guice module {}", (Object)module);
    }

    public static synchronized Injector getInjector() {
        if (defaultModule == null) {
            defaultModule = new ThucydidesModule();
        }
        return Injectors.getInjector(defaultModule);
    }

    public static synchronized Injector getInjector(Module module) {
        String moduleClassName = module.getClass().getCanonicalName();
        Injector injector = injectors.get(moduleClassName);
        if (injector == null) {
            injector = Guice.createInjector((Module[])new Module[]{module});
            injectors.put(moduleClassName, injector);
            LOGGER.debug("Created injector for module {}", (Object)moduleClassName);
        }
        return injector;
    }
}

