/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics.service;

import com.google.common.base.Splitter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.CoreTagProvider;
import net.thucydides.core.statistics.service.TagProvider;
import net.thucydides.core.util.EnvironmentVariables;

public class InjectedTagProvider
implements TagProvider,
CoreTagProvider {
    EnvironmentVariables environmentVariables;

    public InjectedTagProvider() {
        this(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public InjectedTagProvider(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public Set<TestTag> getTagsFor(TestOutcome testOutcome) {
        String injectedTagValues = ThucydidesSystemProperty.INJECTED_TAGS.from(this.environmentVariables, "");
        if (injectedTagValues.isEmpty()) {
            return new HashSet<TestTag>();
        }
        List tags = Splitter.on((String)",").trimResults().splitToList((CharSequence)injectedTagValues);
        return tags.stream().map(TestTag::withValue).collect(Collectors.toSet());
    }
}

