/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model.cucumber;

import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Scenario;
import java.util.Optional;
import net.thucydides.core.requirements.model.cucumber.NamedExampleTable;

public class ReferencedExampleTable {
    private Feature feature;

    public ReferencedExampleTable(Feature feature) {
        this.feature = feature;
    }

    public static ReferencedExampleTable in(Feature feature) {
        return new ReferencedExampleTable(feature);
    }

    public NamedExampleTable withName(String exampleTableName) {
        return this.feature.getChildren().stream().filter(featureChild -> featureChild.getScenario() != null).filter(scenarioDefinition -> this.featureContainsExampleTableWithName(exampleTableName)).map(featureChild -> NamedExampleTable.forScenarioDefinition(this.feature, featureChild.getScenario(), exampleTableName)).findFirst().orElse(NamedExampleTable.withNoMatchingScenario());
    }

    private boolean featureContainsExampleTableWithName(String exampleTableName) {
        return this.feature.getChildren().stream().anyMatch(featureChild -> this.scenarioContainsExampleTableWithName(featureChild.getScenario(), exampleTableName));
    }

    private boolean scenarioContainsExampleTableWithName(Optional<Scenario> scenario, String exampleTableName) {
        if (scenario.isPresent()) {
            if (scenario.get().getExamples() != null && scenario.get().getExamples().isEmpty()) {
                return false;
            }
            return scenario.get().getExamples().stream().anyMatch(examplesTable -> examplesTable.getName().equalsIgnoreCase(exampleTableName.trim()));
        }
        return false;
    }
}

