/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.logging;

import com.google.inject.Inject;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiConsumer;
import net.serenitybdd.core.collect.NewList;
import net.serenitybdd.core.strings.Joiner;
import net.thucydides.core.logging.ConsoleColors;
import net.thucydides.core.logging.ConsoleEvent;
import net.thucydides.core.logging.ConsoleHeading;
import net.thucydides.core.logging.ConsoleHeadingStyle;
import net.thucydides.core.logging.LoggingLevel;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.failures.FailureAnalysis;
import net.thucydides.core.screenshots.ScreenshotAndHtmlSource;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleLoggingListener
implements StepListener {
    public static final String SERENITY_BIG_BANNER = "\n\n-------------------------------------------------------------------------------------\n     _______. _______ .______       _______ .__   __.  __  .___________.____    ____ \n    /       ||   ____||   _  \\     |   ____||  \\ |  | |  | |           |\\   \\  /   / \n   |   (----`|  |__   |  |_)  |    |  |__   |   \\|  | |  | `---|  |----` \\   \\/   /  \n    \\   \\    |   __|  |      /     |   __|  |  . `  | |  |     |  |       \\_    _/   \n.----)   |   |  |____ |  |\\  \\----.|  |____ |  |\\   | |  |     |  |         |  |     \n|_______/    |_______|| _| `._____||_______||__| \\__| |__|     |__|         |__|    \n                                                                                     \n News and tutorials at http://www.serenity-bdd.info                                  \n Documentation at https://wakaleo.gitbooks.io/the-serenity-book/content/             \n Join the Serenity Community on Gitter: https://gitter.im/serenity-bdd/serenity-core \n Serenity BDD Support and Training at http://serenity-bdd.info/#/trainingandsupport  \n-------------------------------------------------------------------------------------\n";
    public static final String SERENITY_SMALL_BANNER = "\n\n____ ____ ____ ____ _  _ _ ___ _   _    ___  ___  ___  \n[__  |___ |__/ |___ |\\ | |  |   \\_/     |__] |  \\ |  \\ \n___] |___ |  \\ |___ | \\| |  |    |      |__] |__/ |__/ \n                                                                                     \n News and tutorials at http://www.serenity-bdd.info                                  \n Documentation at https://wakaleo.gitbooks.io/the-serenity-book/content/             \n Join the Serenity Community on Gitter: https://gitter.im/serenity-bdd/serenity-core \n Serenity BDD Support and Training at http://serenity-bdd.info/#/trainingandsupport  \n-------------------------------------------------------------------------------------\n";
    public static final String SERENITY_NONE_BANNER = "Serenity BDD. Home page at http://www.serenity-bdd.info";
    private static final List<String> BANNER_HEADINGS = NewList.of("Serenity BDD. Home page at http://www.serenity-bdd.info", "\n\n____ ____ ____ ____ _  _ _ ___ _   _    ___  ___  ___  \n[__  |___ |__/ |___ |\\ | |  |   \\_/     |__] |  \\ |  \\ \n___] |___ |  \\ |___ | \\| |  |    |      |__] |__/ |__/ \n                                                                                     \n News and tutorials at http://www.serenity-bdd.info                                  \n Documentation at https://wakaleo.gitbooks.io/the-serenity-book/content/             \n Join the Serenity Community on Gitter: https://gitter.im/serenity-bdd/serenity-core \n Serenity BDD Support and Training at http://serenity-bdd.info/#/trainingandsupport  \n-------------------------------------------------------------------------------------\n", "\n\n-------------------------------------------------------------------------------------\n     _______. _______ .______       _______ .__   __.  __  .___________.____    ____ \n    /       ||   ____||   _  \\     |   ____||  \\ |  | |  | |           |\\   \\  /   / \n   |   (----`|  |__   |  |_)  |    |  |__   |   \\|  | |  | `---|  |----` \\   \\/   /  \n    \\   \\    |   __|  |      /     |   __|  |  . `  | |  |     |  |       \\_    _/   \n.----)   |   |  |____ |  |\\  \\----.|  |____ |  |\\   | |  |     |  |         |  |     \n|_______/    |_______|| _| `._____||_______||__| \\__| |__|     |__|         |__|    \n                                                                                     \n News and tutorials at http://www.serenity-bdd.info                                  \n Documentation at https://wakaleo.gitbooks.io/the-serenity-book/content/             \n Join the Serenity Community on Gitter: https://gitter.im/serenity-bdd/serenity-core \n Serenity BDD Support and Training at http://serenity-bdd.info/#/trainingandsupport  \n-------------------------------------------------------------------------------------\n");
    private final Logger logger;
    private final EnvironmentVariables environmentVariables;
    private final ConsoleHeadingStyle bannerStyle;
    private final FailureAnalysis analysis;
    private final ConsoleHeading consoleHeading;
    private final ConsoleColors colored;
    private ExecutedStepDescription currentStep;
    private Set<ExecutedStepDescription> flaggedSteps = new HashSet<ExecutedStepDescription>();
    private Set<TestOutcome> reportedOutcomes = new HashSet<TestOutcome>();
    private Stack<String> nestedSteps = new Stack();

    public ConsoleLoggingListener(EnvironmentVariables environmentVariables, Logger logger) {
        this.logger = logger;
        this.environmentVariables = environmentVariables;
        this.analysis = new FailureAnalysis(environmentVariables);
        this.consoleHeading = new ConsoleHeading(environmentVariables);
        this.bannerStyle = ConsoleHeadingStyle.bannerStyleDefinedIn(environmentVariables);
        this.colored = new ConsoleColors(environmentVariables);
        this.logBanner();
    }

    @Inject
    public ConsoleLoggingListener(EnvironmentVariables environmentVariables) {
        this(environmentVariables, LoggerFactory.getLogger((String)""));
    }

    protected Logger getLogger() {
        return this.logger;
    }

    private void logBanner() {
        if (this.loggingLevelIsAtLeast(LoggingLevel.QUIET)) {
            this.getLogger().info(this.bannerHeading());
        }
    }

    private String bannerHeading() {
        return this.colored.cyan(BANNER_HEADINGS.get(this.bannerStyle.getLevel()));
    }

    private boolean loggingLevelIsAtLeast(LoggingLevel minimumLoggingLevel) {
        return LoggingLevel.definedIn(this.environmentVariables).isAtLeast(minimumLoggingLevel);
    }

    @Override
    public void testSuiteStarted(Class<?> storyClass) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info("Test Suite Started: " + NameConverter.humanize(storyClass.getSimpleName()));
        }
    }

    @Override
    public void testSuiteStarted(Story story) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info("Test Suite Started: " + NameConverter.humanize(story.getName()));
        }
    }

    @Override
    public void testSuiteFinished() {
    }

    @Override
    public void testStarted(String description) {
        this.flaggedSteps.clear();
        this.reportedOutcomes.clear();
        this.nestedSteps.clear();
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info(this.consoleHeading.bannerFor(ConsoleEvent.TEST_STARTED, description));
        }
    }

    @Override
    public void testStarted(String description, String id) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info(this.consoleHeading.bannerFor(ConsoleEvent.TEST_STARTED, description + "(" + id + ")"));
        }
    }

    @Override
    public void testStarted(String description, String id, ZonedDateTime startTime) {
        this.testStarted(description, id);
    }

    @Override
    public void testFinished(TestOutcome result) {
        if (this.reportedOutcomes.contains(result)) {
            return;
        }
        this.reportedOutcomes.add(result);
        if (result.isManual()) {
            this.logManual(result);
            return;
        }
        if (result.isFailure().booleanValue()) {
            this.logFailure(result);
        }
        if (result.isError().booleanValue()) {
            this.logError(result);
        }
        if (result.isCompromised().booleanValue()) {
            this.logCompromised(result);
        }
        if (result.isPending().booleanValue()) {
            this.logPending(result);
        }
        if (result.isSkipped().booleanValue()) {
            this.logSkipped(result);
        }
        if (result.isSuccess().booleanValue()) {
            this.logSuccess(result);
        }
    }

    @Override
    public void testFinished(TestOutcome result, boolean isInDataDrivenTest) {
        this.testFinished(result);
    }

    @Override
    public void testFinished(TestOutcome result, boolean isInDataDrivenTest, ZonedDateTime finishTime) {
        this.testFinished(result);
    }

    @Override
    public void testRetried() {
    }

    private Map<TestResult, BiConsumer<Logger, String>> coloredLogs() {
        HashMap<TestResult, BiConsumer<Logger, String>> coloredLogs = new HashMap<TestResult, BiConsumer<Logger, String>>();
        coloredLogs.put(TestResult.SUCCESS, (log, msg) -> log.info(this.colored.green((String)msg)));
        coloredLogs.put(TestResult.FAILURE, (log, msg) -> log.error(this.colored.red((String)msg)));
        coloredLogs.put(TestResult.ERROR, (log, msg) -> log.error(this.colored.red((String)msg)));
        coloredLogs.put(TestResult.PENDING, (log, msg) -> log.info(this.colored.cyan((String)msg)));
        coloredLogs.put(TestResult.SKIPPED, (log, msg) -> log.info(this.colored.yellow((String)msg)));
        coloredLogs.put(TestResult.IGNORED, (log, msg) -> log.info(this.colored.yellow((String)msg)));
        coloredLogs.put(TestResult.COMPROMISED, (log, msg) -> log.error(this.colored.purple((String)msg)));
        coloredLogs.put(TestResult.UNDEFINED, (log, msg) -> log.info(msg));
        return coloredLogs;
    }

    private void logManual(TestOutcome result) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.QUIET)) {
            String message = this.consoleHeading.bannerFor(ConsoleEvent.forTestResult(result.getResult()), result.getTitle() + " (manual test)");
            this.coloredLogs().get((Object)result.getResult()).accept(this.getLogger(), message);
            this.logRelatedIssues(result);
        }
    }

    private void logFailure(TestOutcome result) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.QUIET)) {
            this.getLogger().error(this.colored.red(this.consoleHeading.bannerFor(ConsoleEvent.TEST_FAILED, result.getTitle())));
            this.logRelatedIssues(result);
            this.logFailureCause(result);
        }
    }

    private void logError(TestOutcome result) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.QUIET)) {
            this.getLogger().error(this.colored.red(this.consoleHeading.bannerFor(ConsoleEvent.TEST_ERROR, result.getTitle())));
            this.logRelatedIssues(result);
            this.logFailureCause(result);
        }
    }

    private void logCompromised(TestOutcome result) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.QUIET)) {
            this.getLogger().error(this.colored.red(this.consoleHeading.bannerFor(ConsoleEvent.TEST_COMPROMISED, result.getTitle())));
            this.logRelatedIssues(result);
            this.logFailureCause(result);
        }
    }

    private void logRelatedIssues(TestOutcome result) {
        Joiner joiner = Joiner.on(",");
        this.getLogger().debug("RELATED ISSUES: {}", (Object)joiner.join(result.getIssueKeys()));
    }

    private void logFailureCause(TestOutcome result) {
        if (result.getNestedTestFailureCause() != null) {
            if (result.getFailingStep().isPresent()) {
                String failingStep = result.getFailingStep().get().unrendered().getDescription();
                this.getLogger().error(this.colored.red("    Test failed at step: " + failingStep));
            }
            this.getLogger().error(this.colored.red("    " + result.getNestedTestFailureCause().getShortenedMessage()));
        }
    }

    private void logPending(TestOutcome result) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.SUMMARY)) {
            this.getLogger().info(this.colored.cyan(this.consoleHeading.bannerFor(ConsoleEvent.TEST_PENDING, result.getTitle())));
        }
    }

    private void logSkipped(TestOutcome result) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.SUMMARY)) {
            this.getLogger().info(this.colored.yellow(this.consoleHeading.bannerFor(ConsoleEvent.TEST_SKIPPED, result.getTitle())));
        }
    }

    private void logSuccess(TestOutcome result) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.SUMMARY)) {
            this.getLogger().info(this.colored.green(this.consoleHeading.bannerFor(ConsoleEvent.TEST_PASSED, result.getTitle())));
        }
    }

    @Override
    public void stepStarted(ExecutedStepDescription description) {
        this.currentStep = description;
        this.nestedSteps.push(description.getName());
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            String indent = this.indentation(this.nestedSteps.size());
            System.out.println(this.withTimestamp(this.colored.green(indent + description.getTitle())));
        }
    }

    private String withTimestamp(String message) {
        if (this.environmentVariables.getPropertyAsBoolean("serenity.console.timestamp", false).booleanValue()) {
            String timeStamp = new SimpleDateFormat("HH:mm:ss.SSS").format(new Date());
            return timeStamp + " " + message;
        }
        return message;
    }

    private String indentation(int level) {
        return "|" + StringUtils.repeat((String)"-", (int)(level * 2)) + " ";
    }

    @Override
    public void skippedStepStarted(ExecutedStepDescription description) {
        this.stepStarted(description);
    }

    @Override
    public void stepFinished() {
        this.stepOut();
    }

    @Override
    public void stepFinished(List<ScreenshotAndHtmlSource> screenshotList) {
    }

    @Override
    public void stepFailed(StepFailure failure) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            String errorMessage = failure.getException() != null ? failure.getException().toString() : failure.getMessage();
            String failureType = this.analysis.resultFor(failure.getException()).name();
            this.getLogger().info(this.colored.red("STEP {}: {}"), (Object)failureType, (Object)errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void stepOut() {
        ConsoleLoggingListener consoleLoggingListener = this;
        synchronized (consoleLoggingListener) {
            if (!this.nestedSteps.isEmpty()) {
                this.nestedSteps.pop();
            }
        }
    }

    @Override
    public void lastStepFailed(StepFailure failure) {
    }

    @Override
    public void stepIgnored() {
        this.stepOut();
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE) && !this.flaggedSteps.contains(this.currentStep)) {
            this.getLogger().info(this.colored.yellow("      -> STEP IGNORED"));
            this.flaggedSteps.add(this.currentStep);
        }
    }

    @Override
    public void stepPending() {
        this.stepOut();
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE) && !this.flaggedSteps.contains(this.currentStep)) {
            this.getLogger().info(this.colored.cyan("      -> STEP IS PENDING"));
            this.flaggedSteps.add(this.currentStep);
        }
    }

    @Override
    public void stepPending(String message) {
        this.stepOut();
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE) && !this.flaggedSteps.contains(this.currentStep)) {
            this.getLogger().info(this.colored.cyan("      -> PENDING STEP ({})"), (Object)message);
            this.flaggedSteps.add(this.currentStep);
        }
    }

    @Override
    public void testFailed(TestOutcome testOutcome, Throwable cause) {
    }

    @Override
    public void testIgnored() {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info(this.colored.yellow("      -> TEST IGNORED"));
        }
    }

    @Override
    public void testSkipped() {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info(this.colored.yellow("      -> TEST SKIPPED"));
        }
    }

    @Override
    public void testAborted() {
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info(this.colored.yellow("      -> TEST ABORTED"));
        }
    }

    @Override
    public void testPending() {
    }

    @Override
    public void testIsManual() {
    }

    @Override
    public void notifyScreenChange() {
    }

    @Override
    public void useExamplesFrom(DataTable table) {
    }

    @Override
    public void addNewExamplesFrom(DataTable table) {
    }

    @Override
    public void exampleStarted(Map<String, String> data) {
    }

    @Override
    public void exampleFinished() {
    }

    @Override
    public void assumptionViolated(String message) {
        if (this.loggingLevelIsAtLeast(LoggingLevel.QUIET)) {
            this.getLogger().error(this.colored.red("      -> ASSUMPTION VIOLATED: " + message));
        }
    }

    @Override
    public void testRunFinished() {
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info("FINISHING TEST RUN");
        }
    }

    @Override
    public void takeScreenshots(List<ScreenshotAndHtmlSource> screenshots) {
    }
}

