/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.adapters;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.thucydides.core.adapters.TestStrategyAdapter;
import net.thucydides.core.model.TestTag;

public class MultiStrategyAdapter
implements TestStrategyAdapter {
    private List<TestStrategyAdapter> strategies;

    public MultiStrategyAdapter() {
    }

    public MultiStrategyAdapter(List<TestStrategyAdapter> strategies) {
        this.strategies = strategies;
    }

    @Override
    public Optional<String> getTitleAnnotation(Method testMethod) {
        return this.strategies.stream().map(strategy -> strategy.getTitleAnnotation(testMethod)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Override
    public List<TestTag> getTagsFor(Method testMethod) {
        return this.strategies.stream().map(strategy -> strategy.getTagsFor(testMethod)).filter(tags -> !tags.isEmpty()).findFirst().orElse(new ArrayList());
    }

    @Override
    public Double priority() {
        return 0.0;
    }

    @Override
    public boolean isTestClass(Class<?> testClass) {
        if (testClass == null) {
            return false;
        }
        return this.delegateToStrategies(s -> s.isTestClass(testClass));
    }

    @Override
    public boolean isTestMethod(Method method) {
        if (method == null) {
            return false;
        }
        return this.delegateToStrategies(s -> s.isTestMethod(method));
    }

    @Override
    public boolean isTestSetupMethod(Method method) {
        if (method == null) {
            return false;
        }
        return this.delegateToStrategies(s -> s.isTestSetupMethod(method));
    }

    @Override
    public boolean isSerenityTestCase(Class<?> testClass) {
        if (testClass == null) {
            return false;
        }
        return this.delegateToStrategies(s -> s.isSerenityTestCase(testClass));
    }

    @Override
    public boolean isAssumptionViolatedException(Throwable throwable) {
        return this.delegateToStrategies(s -> s.isAssumptionViolatedException(throwable));
    }

    @Override
    public boolean isATaggableClass(Class<?> testClass) {
        if (testClass == null) {
            return false;
        }
        return this.delegateToStrategies(s -> s.isATaggableClass(testClass));
    }

    @Override
    public boolean isIgnored(Method method) {
        if (method == null) {
            return false;
        }
        return this.delegateToStrategies(s -> s.isIgnored(method));
    }

    private boolean delegateToStrategies(Function<TestStrategyAdapter, Boolean> strategyBooleanFunction) {
        return this.strategies.stream().map(strategyBooleanFunction).filter(Boolean::booleanValue).findFirst().orElse(false);
    }
}

