/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.serenitybdd.core.strings.Joiner;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.TestType;
import net.thucydides.core.reports.AsciiColors;
import net.thucydides.core.reports.OutcomeFormat;
import net.thucydides.core.reports.OutcomeSummary;
import net.thucydides.core.reports.TestOutcomeLoader;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.requirements.reports.CompoundDuration;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultChecker {
    private static final String WITH_NO_TAGS = "";
    private final File outputDirectory;
    private EnvironmentVariables environmentVariables;
    private final List<TestTag> tags;
    private final AsciiColors asciiColors;
    private static final Logger logger = LoggerFactory.getLogger(ResultChecker.class);

    public ResultChecker(File outputDirectory) {
        this(outputDirectory, WITH_NO_TAGS);
    }

    public ResultChecker(File outputDirectory, String tags) {
        this(outputDirectory, tags, (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public ResultChecker(File outputDirectory, String tags, EnvironmentVariables environmentVariables) {
        this.outputDirectory = outputDirectory;
        this.tags = this.tagsFrom(tags);
        this.environmentVariables = environmentVariables;
        this.asciiColors = new AsciiColors(environmentVariables);
    }

    private List<TestTag> tagsFrom(String tags) {
        List tagValues = Splitter.on((String)",").trimResults().splitToList((CharSequence)tags);
        return tagValues.stream().map(TestTag::withValue).collect(Collectors.toList());
    }

    public TestResult checkTestResults(TestOutcomes outcomes) {
        if (outcomes != null && !outcomes.isEmpty()) {
            this.logOutcomesFrom(outcomes);
            return outcomes.getResult();
        }
        return TestResult.UNDEFINED;
    }

    public TestResult checkTestResults() {
        Optional<TestOutcomes> outcomes = this.loadOutcomes();
        if (outcomes.isPresent()) {
            return this.checkTestResults(outcomes.get());
        }
        return TestResult.UNDEFINED;
    }

    private void logOutcomesFrom(TestOutcomes testOutcomes) {
        logger.info(this.white("-----------------------------------------"));
        logger.info(this.white(" SERENITY TESTS: ") + this.colored(testOutcomes.getResult(), testOutcomes.getResult().toString()));
        logger.info(this.white("-----------------------------------------"));
        logger.info(this.resultLine(this.white("Tests executed         "), this.white(Integer.toString(testOutcomes.getTotal()))));
        logger.info(this.resultLine(this.green("Tests passed           "), this.green(Integer.toString(testOutcomes.count(TestType.ANY).withResult(TestResult.SUCCESS)))));
        logger.info(this.resultLine(this.red("Tests failed           "), this.red(Integer.toString(testOutcomes.count(TestType.ANY).withResult(TestResult.FAILURE)))));
        logger.info(this.resultLine(this.yellow("Tests with errors      "), this.yellow(Integer.toString(testOutcomes.count(TestType.ANY).withResult(TestResult.ERROR)))));
        logger.info(this.resultLine(this.purple("Tests compromised      "), this.purple(Integer.toString(testOutcomes.count(TestType.ANY).withResult(TestResult.COMPROMISED)))));
        logger.info(this.resultLine(this.purple("Tests aborted          "), this.purple(Integer.toString(testOutcomes.count(TestType.ANY).withResult(TestResult.ABORTED)))));
        logger.info(this.resultLine(this.cyan("Tests pending          "), this.cyan(Integer.toString(testOutcomes.count(TestType.ANY).withResult(TestResult.PENDING)))));
        logger.info(this.resultLine(this.grey("Tests ignored/skipped  "), this.grey(Integer.toString(testOutcomes.count(TestType.ANY).withResult(TestResult.IGNORED) + testOutcomes.count(TestType.ANY).withResult(TestResult.SKIPPED)))));
        logger.info("------------------------ | --------------");
        logger.info(this.resultLine("Total Duration         ", CompoundDuration.of(testOutcomes.getDuration())));
        logger.info(this.resultLine("Fastest test took      ", CompoundDuration.of(testOutcomes.getFastestTestDuration())));
        logger.info(this.resultLine("Slowest test took      ", CompoundDuration.of(testOutcomes.getSlowestTestDuration())));
        logger.info("-----------------------------------------");
        logger.info(WITH_NO_TAGS);
        Path index = this.outputDirectory.toPath().resolve("index.html");
        logger.info(this.white("SERENITY REPORTS"));
        logger.info("  - Full Report: " + index.toUri());
    }

    private String resultLine(String label, String value) {
        return "| " + label + "| " + value;
    }

    private String pad(String text, int totalLength) {
        return StringUtils.rightPad((String)text, (int)totalLength);
    }

    private String colored(TestResult result, String text) {
        switch (result) {
            case SUCCESS: {
                return this.green(text);
            }
            case FAILURE: {
                return this.red(text);
            }
            case ERROR: {
                return this.yellow(text);
            }
            case PENDING: {
                return this.cyan(text);
            }
        }
        return text;
    }

    private String red(String text) {
        return this.asciiColors.bold().red(text);
    }

    private String green(String text) {
        return this.asciiColors.bold().green(text);
    }

    private String cyan(String text) {
        return this.asciiColors.bold().cyan(text);
    }

    private String grey(String text) {
        return this.asciiColors.bold().grey(text);
    }

    private String yellow(String text) {
        return this.asciiColors.bold().yellow(text);
    }

    private String purple(String text) {
        return this.asciiColors.bold().magenta(text);
    }

    private String white(String text) {
        return this.asciiColors.bold().white(text);
    }

    private String testOutcomeSummary(TestOutcomes testOutcomes) {
        int errors = testOutcomes.count(TestType.ANY).withResult(TestResult.ERROR);
        int failures = testOutcomes.count(TestType.ANY).withResult(TestResult.FAILURE);
        int compromised = testOutcomes.count(TestType.ANY).withResult(TestResult.COMPROMISED);
        return Joiner.on(" ").join("SERENITY TEST FAILURES:", OutcomeSummary.forOutcome(TestResult.ERROR).withCount(errors), OutcomeSummary.forOutcome(TestResult.FAILURE).withCount(failures), OutcomeSummary.forOutcome(TestResult.COMPROMISED).withCount(compromised));
    }

    private Optional<TestOutcomes> loadOutcomes() {
        TestOutcomes outcomes = null;
        try {
            outcomes = TestOutcomeLoader.loadTestOutcomes().inFormat(OutcomeFormat.JSON).from(this.outputDirectory).filteredByEnvironmentTags();
            if (this.thereAreTagsIn(this.tags)) {
                outcomes = outcomes.withTags(this.tags);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Optional.ofNullable(outcomes);
    }

    private boolean thereAreTagsIn(List<TestTag> tags) {
        return !tags.isEmpty() && !StringUtils.isBlank((CharSequence)tags.get(0).getName());
    }
}

