/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import net.thucydides.core.model.TestResult;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.reports.RequirmentCalculator;

public class ChildRequirementCounter
implements RequirmentCalculator {
    private final Requirement requirement;
    private final TestOutcomes testOutcomes;

    public ChildRequirementCounter(Requirement requirement, TestOutcomes testOutcomes) {
        this.requirement = requirement;
        this.testOutcomes = testOutcomes;
    }

    @Override
    public int countAllSubrequirements() {
        return this.requirement.getChildren().size();
    }

    @Override
    public int countSubrequirementsWithResult(TestResult expectedResult) {
        int totalSubrequirmentsWithResult = 0;
        for (Requirement req : this.requirement.getChildren()) {
            if (this.testResultFor(req) != expectedResult) continue;
            ++totalSubrequirmentsWithResult;
        }
        return totalSubrequirmentsWithResult;
    }

    @Override
    public int countSubrequirementsWithNoTests() {
        int totalSubrequirmentsWithNoTests = 0;
        for (Requirement req : this.requirement.getChildren()) {
            if (!this.testOutcomes.forRequirement(req).getOutcomes().isEmpty()) continue;
            ++totalSubrequirmentsWithNoTests;
        }
        return totalSubrequirmentsWithNoTests;
    }

    private TestResult testResultFor(Requirement req) {
        if (this.testOutcomes.forRequirement(req).getOutcomes().isEmpty()) {
            return TestResult.UNDEFINED;
        }
        return this.testOutcomes.forRequirement(req).getResult();
    }
}

