/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.json.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class ZonedDateTimeAdapter
implements JsonDeserializer<ZonedDateTime>,
JsonSerializer<ZonedDateTime> {
    public ZonedDateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonPrimitive jsonPrimitive = json.getAsJsonPrimitive();
        try {
            if (jsonPrimitive.isString()) {
                return ZonedDateTime.parse(jsonPrimitive.getAsString());
            }
            if (jsonPrimitive.isNumber()) {
                return ZonedDateTime.ofInstant(Instant.ofEpochMilli(jsonPrimitive.getAsLong()), ZoneId.systemDefault());
            }
        }
        catch (RuntimeException e) {
            throw new JsonParseException("Unable to parse ZonedDateTime", (Throwable)e);
        }
        throw new JsonParseException("Unable to parse ZonedDateTime");
    }

    public JsonElement serialize(ZonedDateTime src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(src.toString());
    }
}

