/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValueFactory;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestFullReporter;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.FormatConfiguration;
import net.thucydides.core.reports.ReportGenerationFailedError;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.junit.JUnitXMLOutcomeReporter;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportService {
    private final int maximumPoolSize;
    private File outputDirectory;
    private List<AcceptanceTestFullReporter> subscribedFullReporters;
    private List<AcceptanceTestReporter> subscribedReporters;
    private JUnitXMLOutcomeReporter jUnitXMLOutcomeReporter;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportService.class);

    @Inject
    public ReportService(Configuration configuration) {
        this(configuration.getOutputDirectory(), ReportService.getDefaultReporters(), configuration.getEnvironmentVariables());
    }

    public ReportService(File outputDirectory, Collection<AcceptanceTestReporter> subscribedReporters) {
        this(outputDirectory, subscribedReporters, (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public ReportService(File outputDirectory, Collection<AcceptanceTestReporter> subscribedReporters, EnvironmentVariables environmentVariables) {
        this(outputDirectory, subscribedReporters, ReportService.getDefaultFullReporters(), environmentVariables);
    }

    public ReportService(File outputDirectory, Collection<AcceptanceTestReporter> subscribedReporters, Collection<AcceptanceTestFullReporter> subscribedFullReporters, EnvironmentVariables environmentVariables) {
        this.outputDirectory = outputDirectory;
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        this.getSubscribedReporters().addAll(subscribedReporters);
        this.getSubscribedFullReporters().addAll(subscribedFullReporters);
        this.jUnitXMLOutcomeReporter = new JUnitXMLOutcomeReporter(outputDirectory);
        this.maximumPoolSize = ThucydidesSystemProperty.REPORT_MAX_THREADS.integerFrom(environmentVariables, Runtime.getRuntime().availableProcessors());
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public List<AcceptanceTestReporter> getSubscribedReporters() {
        if (this.subscribedReporters == null) {
            this.subscribedReporters = new ArrayList<AcceptanceTestReporter>();
        }
        return this.subscribedReporters;
    }

    public List<AcceptanceTestFullReporter> getSubscribedFullReporters() {
        if (this.subscribedFullReporters == null) {
            this.subscribedFullReporters = new ArrayList<AcceptanceTestFullReporter>();
        }
        return this.subscribedFullReporters;
    }

    public void subscribe(AcceptanceTestReporter reporter) {
        this.getSubscribedReporters().add(reporter);
    }

    public void useQualifier(String qualifier) {
        for (AcceptanceTestReporter reporter : this.getSubscribedReporters()) {
            reporter.setQualifier(qualifier);
        }
    }

    public void generateReportsFor(List<TestOutcome> testOutcomeResults) {
        TestOutcomes allTestOutcomes = TestOutcomes.of(testOutcomeResults);
        for (AcceptanceTestReporter acceptanceTestReporter : this.getSubscribedReporters()) {
            this.generateReportsFor(acceptanceTestReporter, allTestOutcomes);
        }
        for (AcceptanceTestFullReporter acceptanceTestFullReporter : this.getSubscribedFullReporters()) {
            this.generateFullReportFor(allTestOutcomes, acceptanceTestFullReporter);
        }
        this.generateJUnitTestResults(allTestOutcomes);
    }

    public void generateConfigurationsReport() {
        Configuration configuration = ConfiguredEnvironment.getConfiguration();
        Config config = ConfigFactory.empty();
        config = config.withValue(ThucydidesSystemProperty.SERENITY_OUTPUT_DIRECTORY.preferredName(), ConfigValueFactory.fromAnyRef((Object)configuration.getOutputDirectory().getAbsolutePath()));
        try {
            boolean autoFlush = true;
            Path flow = this.outputDirectory.toPath().resolve(ThucydidesSystemProperty.SERENITY_FLOW_REPORTS_DIR.preferredName());
            Path file = flow.resolve(ThucydidesSystemProperty.SERENITY_CONFIGURATION_REPORT.preferredName());
            Files.createDirectories(flow, new FileAttribute[0]);
            try (PrintWriter writer = new PrintWriter((Writer)Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]), true);){
                LOGGER.debug("Generating report for configuration");
                ((Writer)writer).write(config.root().render(ConfigRenderOptions.concise().setJson(true)));
            }
        }
        catch (Exception e) {
            throw new ReportGenerationFailedError("Failed to generate configuration reports", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateReportsFor(AcceptanceTestReporter reporter, TestOutcomes testOutcomes) {
        LOGGER.debug("Generating reports for " + testOutcomes.getTotalTestScenarios() + " test outcomes using: " + reporter);
        long t0 = System.currentTimeMillis();
        List<? extends TestOutcome> outcomes = testOutcomes.getOutcomes();
        ExecutorService executorService = Executors.newFixedThreadPool(this.maximumPoolSize);
        try {
            ArrayList<Future> tasks = new ArrayList<Future>(outcomes.size());
            for (TestOutcome testOutcome : outcomes) {
                tasks.add(executorService.submit(() -> {
                    LOGGER.debug("Processing test outcome " + outcome.getCompleteName());
                    this.generateReportFor(outcome, reporter);
                    LOGGER.debug("Processing test outcome " + outcome.getCompleteName() + " done");
                }));
            }
            this.waitForReportGenerationToFinish(tasks);
        }
        finally {
            LOGGER.debug("Shutting down executor service");
            executorService.shutdown();
        }
        LOGGER.debug("Reports generated in: " + (System.currentTimeMillis() - t0) + " ms");
    }

    private void generateJUnitTestResults(TestOutcomes outcomes) {
        this.jUnitXMLOutcomeReporter.generateReportsFor(outcomes);
    }

    private void waitForReportGenerationToFinish(List<Future> tasks) {
        try {
            for (Future task : tasks) {
                task.get();
            }
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            throw new ReportGenerationFailedError("Failed to generate configuration report", e);
        }
    }

    public static List<AcceptanceTestReporter> getDefaultReporters() {
        ArrayList<AcceptanceTestReporter> reporters = new ArrayList<AcceptanceTestReporter>();
        FormatConfiguration formatConfiguration = new FormatConfiguration((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
        ServiceLoader<AcceptanceTestReporter> reporterServiceLoader = ServiceLoader.load(AcceptanceTestReporter.class);
        Iterator<AcceptanceTestReporter> reporterImplementations = reporterServiceLoader.iterator();
        LOGGER.debug("Reporting formats: " + formatConfiguration.getFormats());
        while (reporterImplementations.hasNext()) {
            AcceptanceTestReporter reporter = reporterImplementations.next();
            LOGGER.trace("Found reporter: " + reporter + "(format = " + reporter.getFormat() + ")");
            if (reporter.getFormat().isPresent() && !formatConfiguration.getFormats().contains((Object)reporter.getFormat().get())) continue;
            LOGGER.trace("Registering reporter: " + reporter);
            reporters.add(reporter);
        }
        return reporters;
    }

    private void generateReportFor(TestOutcome testOutcome, AcceptanceTestReporter reporter) {
        try {
            LOGGER.info(reporter + ": Generating report for test outcome: " + testOutcome.getCompleteName());
            reporter.setOutputDirectory(this.outputDirectory);
            reporter.generateReportFor(testOutcome);
        }
        catch (Exception e) {
            throw new ReportGenerationFailedError("Failed to generate reports using " + reporter, e);
        }
    }

    public static List<AcceptanceTestFullReporter> getDefaultFullReporters() {
        ArrayList<AcceptanceTestFullReporter> reporters = new ArrayList<AcceptanceTestFullReporter>();
        FormatConfiguration formatConfiguration = new FormatConfiguration((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
        ServiceLoader<AcceptanceTestFullReporter> reporterServiceLoader = ServiceLoader.load(AcceptanceTestFullReporter.class);
        Iterator<AcceptanceTestFullReporter> reporterImplementations = reporterServiceLoader.iterator();
        LOGGER.debug("Reporting formats: " + formatConfiguration.getFormats());
        while (reporterImplementations.hasNext()) {
            AcceptanceTestFullReporter reporter = reporterImplementations.next();
            LOGGER.debug("Found reporter: " + reporter + "(format = " + reporter.getFormat() + ")");
            if (reporter.getFormat().isPresent() && !formatConfiguration.getFormats().contains((Object)reporter.getFormat().get())) continue;
            LOGGER.debug("Registering reporter: " + reporter);
            reporters.add(reporter);
        }
        return reporters;
    }

    private void generateFullReportFor(TestOutcomes testOutcomes, AcceptanceTestFullReporter reporter) {
        try {
            reporter.setOutputDirectory(this.outputDirectory);
            reporter.generateReportsFor(testOutcomes);
        }
        catch (Exception e) {
            throw new ReportGenerationFailedError("Failed to generate reports using " + reporter, e);
        }
    }
}

