/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class ErrorMessageFormatter {
    private final Optional<String> originalMessage;
    Pattern LEADING_EXCEPTIONS = Pattern.compile("^<?([\\w]*\\.[\\w]*)+:");

    public ErrorMessageFormatter(String originalMessage) {
        this.originalMessage = Optional.ofNullable(originalMessage);
    }

    public String getShortErrorMessage() {
        return this.escapedHtml(this.originalMessage.isPresent() ? this.getUsefulMessageSummary() : "");
    }

    private String escapedHtml(String message) {
        return StringEscapeUtils.escapeHtml4((String)message);
    }

    private String getUsefulMessageSummary() {
        if (this.isHamcrestException()) {
            return this.compressedHamcrestMessage();
        }
        return this.extractFirstLine();
    }

    private String compressedHamcrestMessage() {
        String messageWithoutExceptions = this.removeLeadingExceptionFrom(this.originalMessage.get());
        Object[] words = StringUtils.split((String)messageWithoutExceptions);
        return StringUtils.join((Object[])words, (String)" ");
    }

    private String extractFirstLine() {
        String[] lines = this.originalMessage.get().split("\\r?\\n");
        return StringUtils.trimToEmpty((String)this.replaceDoubleQuotesIn(this.firstNonExceptionLineIn(lines)));
    }

    private String firstNonExceptionLineIn(String[] lines) {
        for (String candidateLine : lines) {
            String lineWithoutExceptions = this.removeLeadingExceptionFrom(candidateLine);
            if (!StringUtils.isNotEmpty((CharSequence)lineWithoutExceptions)) continue;
            return lineWithoutExceptions;
        }
        return "";
    }

    private String removeLeadingExceptionFrom(String message) {
        Matcher matcher = this.LEADING_EXCEPTIONS.matcher(message);
        if (matcher.find()) {
            return matcher.replaceFirst("");
        }
        return message;
    }

    private boolean isHamcrestException() {
        return this.originalMessage.get().contains("Expected:");
    }

    private String replaceDoubleQuotesIn(String message) {
        return message.replaceAll("\"", "'");
    }
}

