/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model.cucumber;

import io.cucumber.messages.Messages;
import net.thucydides.core.requirements.model.cucumber.NamedExampleTable;

public class ReferencedExampleTable {
    private Messages.GherkinDocument.Feature feature;

    public ReferencedExampleTable(Messages.GherkinDocument.Feature feature) {
        this.feature = feature;
    }

    public static ReferencedExampleTable in(Messages.GherkinDocument.Feature feature) {
        return new ReferencedExampleTable(feature);
    }

    public NamedExampleTable withName(String exampleTableName) {
        return this.feature.getChildrenList().stream().filter(featureChild -> featureChild.hasScenario()).filter(scenarioDefinition -> this.featureContainsExampleTableWithName(exampleTableName)).map(featureChild -> NamedExampleTable.forScenarioDefinition(this.feature, featureChild.getScenario(), exampleTableName)).findFirst().orElse(NamedExampleTable.withNoMatchingScenario());
    }

    private boolean featureContainsExampleTableWithName(String exampleTableName) {
        return this.feature.getChildrenList().stream().anyMatch(featureChild -> this.scenarioContainsExampleTableWithName(featureChild.getScenario(), exampleTableName));
    }

    private boolean scenarioContainsExampleTableWithName(Messages.GherkinDocument.Feature.Scenario scenario, String exampleTableName) {
        if (scenario.getExamplesCount() == 0) {
            return false;
        }
        return scenario.getExamplesList().stream().anyMatch(examplesTable -> examplesTable.getName().equalsIgnoreCase(exampleTableName.trim()));
    }
}

