/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core;

import net.thucydides.core.ThucydidesSystemProperty;
import org.apache.commons.lang3.StringUtils;

public class SerenitySystemProperties {
    static SerenitySystemProperties currentSystemProperties = new SerenitySystemProperties();

    public static SerenitySystemProperties getProperties() {
        return currentSystemProperties;
    }

    public String getValue(ThucydidesSystemProperty property) {
        return System.getProperty(property.getPropertyName());
    }

    public boolean isDefined(ThucydidesSystemProperty property) {
        return System.getProperty(property.getPropertyName()) != null;
    }

    public String getValue(ThucydidesSystemProperty property, String defaultValue) {
        return this.isDefined(property) ? this.getValue(property) : defaultValue;
    }

    public boolean isEmpty(ThucydidesSystemProperty property) {
        String value = System.getProperty(property.getPropertyName());
        return StringUtils.isEmpty((CharSequence)value);
    }

    public void setValue(ThucydidesSystemProperty property, String value) {
        System.setProperty(property.getPropertyName(), value);
    }

    public Integer getIntegerValue(ThucydidesSystemProperty property, Integer defaultValue) {
        String value = System.getProperty(property.getPropertyName());
        if (value != null) {
            return Integer.valueOf(value);
        }
        return defaultValue;
    }

    public Boolean getBooleanValue(ThucydidesSystemProperty property, boolean defaultValue) {
        String value = System.getProperty(property.getPropertyName());
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }
}

