/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.adaptors.specflow;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.DataTableRow;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.reports.adaptors.common.FilebasedOutcomeAdaptor;
import net.thucydides.core.reports.adaptors.specflow.ScenarioSplitter;
import net.thucydides.core.reports.adaptors.specflow.ScenarioStepReader;
import net.thucydides.core.reports.adaptors.specflow.SpecflowScenario;
import net.thucydides.core.reports.adaptors.specflow.SpecflowScenarioTitleLine;
import net.thucydides.core.reports.adaptors.specflow.SpecflowTableRow;

public class SpecflowAdaptor
extends FilebasedOutcomeAdaptor {
    private static final String TITLE_LEAD = "***** ";

    @Override
    public List<TestOutcome> loadOutcomesFrom(File source) throws IOException {
        if (source.isDirectory()) {
            ArrayList<TestOutcome> outcomes = new ArrayList<TestOutcome>();
            for (File outputFile : source.listFiles()) {
                outcomes.addAll(this.outcomesFromFile(outputFile));
            }
            return outcomes;
        }
        return this.outcomesFromFile(source);
    }

    private List<TestOutcome> outcomesFromFile(File outputFile) throws IOException {
        List<String> outputLines = Files.readAllLines(outputFile.toPath(), Charset.defaultCharset());
        return this.scenarioOutputsFrom(outputLines).stream().map(this::toTestOutcome).collect(Collectors.toList());
    }

    private TestOutcome toTestOutcome(List<String> outputLines) {
        SpecflowScenarioTitleLine titleLine = new SpecflowScenarioTitleLine(outputLines.get(0));
        Story story = Story.called(titleLine.getStoryTitle()).withPath(titleLine.getStoryPath());
        TestOutcome outcome = TestOutcome.forTestInStory(titleLine.getScenarioTitle(), story);
        for (SpecflowScenario scenario : ScenarioSplitter.on(outputLines).split()) {
            if (scenario.usesDataTable()) {
                DataTable dataTable = DataTable.withHeaders(this.headersFrom(titleLine)).build();
                outcome.useExamplesFrom(dataTable);
                this.recordRowSteps(outcome, scenario);
                continue;
            }
            outcome.recordSteps(this.stepsFrom(scenario.getSteps()));
        }
        return outcome;
    }

    private void recordRowSteps(TestOutcome outcome, SpecflowScenario scenario) {
        for (SpecflowTableRow row : scenario.getRows()) {
            List<TestStep> rowSteps = this.stepsFrom(row.getRowSteps());
            SpecflowScenarioTitleLine rowTitle = new SpecflowScenarioTitleLine(row.getRowTitle());
            TestResult rowResult = TestResultList.overallResultFrom(this.getTestResults(rowSteps));
            DataTableRow dataTableRow = new DataTableRow(rowTitle.getArguments(), 0);
            dataTableRow.setResult(rowResult);
            outcome.addRow(dataTableRow);
            outcome.recordStep(TestStep.forStepCalled(rowTitle.getRowTitle()).withResult(rowResult));
            outcome.startGroup();
            outcome.recordSteps(rowSteps);
            outcome.endGroup();
        }
    }

    private List<String> headersFrom(SpecflowScenarioTitleLine titleLine) {
        ArrayList<String> headers = new ArrayList<String>();
        for (int i = 0; i < titleLine.getArguments().size(); ++i) {
            headers.add(Character.toString((char)(65 + i)));
        }
        return headers;
    }

    private List<TestStep> stepsFrom(List<String> scenarioOutput) {
        ArrayList<TestStep> discoveredSteps = new ArrayList<TestStep>();
        ScenarioStepReader stepReader = new ScenarioStepReader();
        List<String> lines = NewList.copyOf(scenarioOutput);
        while (!lines.isEmpty()) {
            discoveredSteps.add(stepReader.consumeNextStepFrom(lines));
        }
        return NewList.copyOf(discoveredSteps);
    }

    private List<List<String>> scenarioOutputsFrom(List<String> outputLines) {
        ArrayList scenarios = new ArrayList();
        ArrayList<String> currentScenario = null;
        SpecflowScenarioTitleLine currentTitle = null;
        for (String line : outputLines) {
            if (this.isTitle(line)) {
                SpecflowScenarioTitleLine newTitleLine = new SpecflowScenarioTitleLine(line);
                if (currentTitle == null || !newTitleLine.getTitleName().equals(currentTitle.getTitleName())) {
                    currentTitle = new SpecflowScenarioTitleLine(line);
                    currentScenario = new ArrayList<String>();
                    scenarios.add(currentScenario);
                }
            }
            if (currentScenario == null) continue;
            currentScenario.add(line);
        }
        return NewList.copyOf(scenarios);
    }

    private boolean isTitle(String line) {
        return line.trim().startsWith(TITLE_LEAD);
    }

    private List<TestResult> getTestResults(List<TestStep> testSteps) {
        return testSteps.stream().map(TestStep::getResult).collect(Collectors.toList());
    }
}

