/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultComparison;

public class DataTableRow {
    private final List<?> values;
    private final int lineNumber;
    private TestResult result;

    public DataTableRow(List<?> values) {
        this(values, 0, TestResult.UNDEFINED);
    }

    public DataTableRow(List<?> values, int lineNumber) {
        this(values, lineNumber, TestResult.UNDEFINED);
    }

    public DataTableRow(List<?> values, int lineNumber, TestResult result) {
        this.values = new ArrayList(values);
        this.result = result;
        this.lineNumber = lineNumber;
    }

    public List<?> getValues() {
        return new ArrayList(this.values);
    }

    public List<String> getStringValues() {
        return this.values.stream().map(value -> value == null ? "" : value.toString()).collect(Collectors.toList());
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public TestResult getResult() {
        return this.result;
    }

    public void setResult(TestResult result) {
        this.result = result;
    }

    public void updateResult(TestResult newResult) {
        if (newResult == TestResult.UNDEFINED) {
            this.setResult(newResult);
        } else {
            this.setResult(TestResultComparison.overallResultFor(this.result, newResult));
        }
    }

    public String toString() {
        return "DataTableRow{values=" + this.values + ", result=" + (Object)((Object)this.result) + '}';
    }
}

