/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.runners;

import java.util.ArrayList;
import java.util.List;
import net.serenitybdd.model.collect.NewList;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestStep;
import net.thucydides.model.steps.StepListenerAdapter;
import net.thucydides.model.steps.TestFailureCause;

public class FailureDetectingStepListener
extends StepListenerAdapter {
    private boolean lastTestFailed = false;
    private final List<String> failureMessages = new ArrayList<String>();
    private TestFailureCause testFailureCause;

    public void reset() {
        this.lastTestFailed = false;
        this.failureMessages.clear();
    }

    public boolean lastTestFailed() {
        return this.lastTestFailed;
    }

    public void testFailed(TestOutcome testOutcome, Throwable cause) {
        this.lastTestFailed = true;
        String failingStep = testOutcome.getFailingStep().isPresent() ? ((TestStep)testOutcome.getFailingStep().get()).getDescription() + ":" : "";
        this.failureMessages.add(failingStep + testOutcome.getErrorMessage());
        this.testFailureCause = TestFailureCause.from((Throwable)cause);
    }

    public void testStarted(String description) {
        this.lastTestFailed = false;
    }

    public void testStarted(String description, String id) {
        this.lastTestFailed = false;
    }

    public TestFailureCause getTestFailureCause() {
        return this.testFailureCause;
    }

    public List<String> getFailureMessages() {
        return NewList.copyOf(this.failureMessages);
    }
}

