/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.runners;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thucydides.core.configuration.FilePathParser;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.steps.stepdata.CSVTestDataSource;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.junit.annotations.TestData;
import net.thucydides.junit.annotations.UseTestDataFrom;
import org.apache.commons.lang3.StringUtils;

public class DataDrivenAnnotations {
    private final EnvironmentVariables environmentVariables;
    private final Pattern DATASOURCE_PATH_SEPARATORS = Pattern.compile("[;,]");
    private final Class testClass;

    public static DataDrivenAnnotations forClass(Class testClass) {
        return new DataDrivenAnnotations(testClass);
    }

    DataDrivenAnnotations(Class testClass) {
        this(testClass, SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    DataDrivenAnnotations(Class testClass, EnvironmentVariables environmentVariables) {
        this.testClass = testClass;
        this.environmentVariables = environmentVariables;
    }

    public DataDrivenAnnotations usingEnvironmentVariables(EnvironmentVariables environmentVariables) {
        return new DataDrivenAnnotations(this.testClass, environmentVariables);
    }

    public DataTable getParametersTableFromTestDataSource() throws Throwable {
        CSVTestDataSource testDataSource = new CSVTestDataSource(this.findTestDataSource(), this.findTestDataSeparator());
        List testData = testDataSource.getData();
        List headers = testDataSource.getHeaders();
        return DataTable.withHeaders((List)headers).andMappedRows(testData).build();
    }

    public List<Method> getTestMethods() {
        List<Method> methods = this.getAnnotatedMethods();
        if (methods.isEmpty()) {
            throw new IllegalStateException("Parameterized test should have at least one @Test method");
        }
        return methods;
    }

    public DataTable getParametersTableFromTestDataAnnotation() {
        List parametersList;
        String columnNamesString;
        try {
            Method testDataMethod = this.getTestDataMethod();
            columnNamesString = testDataMethod.getAnnotation(TestData.class).columnNames();
            parametersList = (List)testDataMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not obtain test data from the test class", e);
        }
        ArrayList<List<Object>> parametersAsListsOfObjects = new ArrayList<List<Object>>();
        for (Object parameterList : parametersList) {
            parametersAsListsOfObjects.add(this.listOfObjectsFrom((Object[])parameterList));
        }
        return this.createParametersTableFrom(columnNamesString, parametersAsListsOfObjects);
    }

    private List<Object> listOfObjectsFrom(Object[] parameters) {
        return Arrays.asList(parameters);
    }

    private DataTable createParametersTableFrom(String columnNamesString, List<List<Object>> parametersList) {
        int numberOfColumns = parametersList.isEmpty() ? 0 : parametersList.get(0).size();
        List<String> columnNames = this.split(columnNamesString, numberOfColumns);
        return DataTable.withHeaders(columnNames).andRows(parametersList).build();
    }

    private List<String> split(String columnNamesString, int numberOfColumns) {
        if (StringUtils.isEmpty((CharSequence)columnNamesString)) {
            return this.numberedColumnHeadings(numberOfColumns);
        }
        return Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)columnNamesString);
    }

    private List<String> numberedColumnHeadings(int numberOfColumns) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 0; i < numberOfColumns; ++i) {
            columnNames.add("Parameter " + (i + 1));
        }
        return columnNames;
    }

    public Method getTestDataMethod() throws Exception {
        Method method = this.findTestDataMethod();
        if (method == null) {
            throw new IllegalArgumentException("No public static @FilePathParser method on class " + this.testClass.getName());
        }
        return method;
    }

    private Method findTestDataMethod() {
        List<Method> methods = this.getAnnotatedMethods(TestData.class);
        for (Method each : methods) {
            int modifiers = each.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            return each;
        }
        return null;
    }

    protected List<String> findTestDataSource() {
        String paths = this.findTestDataSourcePaths();
        ArrayList<String> validPaths = new ArrayList<String>();
        for (String path : Splitter.on((Pattern)this.DATASOURCE_PATH_SEPARATORS).split((CharSequence)paths)) {
            if (!CSVTestDataSource.validTestDataPath((String)path)) continue;
            validPaths.add(path);
        }
        if (validPaths.isEmpty()) {
            throw new IllegalArgumentException("No test data file found for path: " + paths);
        }
        return validPaths;
    }

    protected String findTestDataSourcePaths() {
        return new FilePathParser(this.environmentVariables).getInstanciatedPath(this.findUseTestDataFromAnnotation().value());
    }

    private UseTestDataFrom findUseTestDataFromAnnotation() {
        return this.testClass.getAnnotation(UseTestDataFrom.class);
    }

    public boolean hasTestDataDefined() {
        return this.findTestDataMethod() != null;
    }

    public boolean hasTestDataSourceDefined() {
        return this.findUseTestDataFromAnnotation() != null && this.findTestDataSource() != null;
    }

    public <T> List<T> getDataAsInstancesOf(Class<T> clazz) throws IOException {
        CSVTestDataSource testdata = new CSVTestDataSource(this.findTestDataSource(), this.findTestDataSeparator());
        return testdata.getDataAsInstancesOf(clazz, new Object[0]);
    }

    public int countDataEntries() throws IOException {
        CSVTestDataSource testdata = new CSVTestDataSource(this.findTestDataSource(), this.findTestDataSeparator());
        return testdata.getData().size();
    }

    private char findTestDataSeparator() {
        return this.findUseTestDataFromAnnotation().separator();
    }

    private List<Method> getAnnotatedMethods() {
        return Arrays.stream(this.testClass.getDeclaredMethods()).filter(method -> method.getDeclaredAnnotations() != null).collect(Collectors.toList());
    }

    private List<Method> getAnnotatedMethods(Class<? extends Annotation> annotationClass) {
        return Arrays.stream(this.testClass.getDeclaredMethods()).filter(method -> method.getAnnotation(annotationClass) != null).collect(Collectors.toList());
    }
}

