/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.runners;

import net.thucydides.core.model.TestStep;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepPublisher;
import org.junit.AssumptionViolatedException;
import org.junit.runners.model.Statement;

class SerenityStatement
extends Statement {
    private final Statement statement;
    private final StepPublisher publisher;

    SerenityStatement(Statement statement, StepPublisher publisher) {
        this.statement = statement;
        this.publisher = publisher;
    }

    StepEventBus stepEventBus() {
        if (this.publisher instanceof BaseStepListener) {
            return ((BaseStepListener)this.publisher).getEventBus();
        }
        return StepEventBus.getParallelEventBus();
    }

    public void evaluate() throws Throwable {
        block3: {
            try {
                this.updateCurrentEventBusFrom(this.publisher);
                this.statement.evaluate();
            }
            catch (AssumptionViolatedException assumptionViolated) {
                this.stepEventBus().assumptionViolated(assumptionViolated.getMessage());
            }
            catch (AssertionError assertionError) {
                if (this.stepEventBus().aStepInTheCurrentTestHasFailed()) break block3;
                throw assertionError;
            }
        }
        this.checkForStepFailures();
        this.checkForAssumptionViolations();
    }

    private void updateCurrentEventBusFrom(StepPublisher publisher) {
        if (StepEventBus.getParallelEventBus() != this.stepEventBus()) {
            StepEventBus.overrideEventBusWith((StepEventBus)this.stepEventBus());
        }
    }

    private void checkForStepFailures() throws Throwable {
        if (this.publisher.aStepHasFailed()) {
            if (this.publisher.getTestFailureCause() != null) {
                throw this.publisher.getTestFailureCause().toException();
            }
            if (this.publisher.firstFailingStep().isPresent()) {
                throw ((TestStep)this.publisher.firstFailingStep().get()).getException().asException();
            }
        }
    }

    private void checkForAssumptionViolations() {
        if (this.stepEventBus().assumptionViolated()) {
            throw new AssumptionViolatedException(this.stepEventBus().getAssumptionViolatedMessage());
        }
    }
}

