/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.util;

import io.cucumber.tagexpressions.Expression;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class TagParser {
    public static Expression parseFromTagFilters(List<String> stringList) {
        String combinedExpression = stringList.isEmpty() ? "" : stringList.stream().filter(StringUtils::isNotEmpty).map(tagExpression -> tagExpression.replace("~", "not ")).collect(Collectors.joining(") and (", "(", ")"));
        return TagExpressionParser.parse((String)combinedExpression);
    }

    public static Collection<String> additionalTagsSuppliedFrom(EnvironmentVariables environmentVariables, List<String> existingTags) {
        String tagsExpression = ThucydidesSystemProperty.TAGS.from(environmentVariables, "");
        return Stream.of(StringUtils.split((String)tagsExpression, (String)",")).map(TagParser::toCucumberTag).filter(tag -> !existingTags.contains(tag)).collect(Collectors.toList());
    }

    private static String toCucumberTag(String from) {
        String tag = from.trim().replaceAll(":", "=");
        if (tag.startsWith("~@") || tag.startsWith("@")) {
            return tag;
        }
        if (tag.startsWith("~")) {
            return "~@" + tag.substring(1);
        }
        return "@" + tag;
    }
}

