/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.suiteslicing;

import com.google.common.collect.FluentIterable;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.feature.Options;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.messages.internal.gherkin.GherkinDocumentBuilder;
import io.cucumber.core.gherkin.messages.internal.gherkin.Parser;
import io.cucumber.core.gherkin.messages.internal.gherkin.TokenMatcher;
import io.cucumber.core.runtime.FeaturePathFeatureSupplier;
import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.Messages;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.serenitybdd.cucumber.suiteslicing.TestStatistics;
import net.serenitybdd.cucumber.suiteslicing.WeightedCucumberScenario;
import net.serenitybdd.cucumber.suiteslicing.WeightedCucumberScenarios;
import net.serenitybdd.cucumber.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberScenarioLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CucumberScenarioLoader.class);
    private final Supplier<ClassLoader> classLoader = CucumberScenarioLoader.class::getClassLoader;
    private final FeatureParser parser = new FeatureParser(UUID::randomUUID);
    private final List<URI> featurePaths;
    private final TestStatistics statistics;
    private Map<Messages.GherkinDocument.Feature, URI> mapsForFeatures = new HashMap<Messages.GherkinDocument.Feature, URI>();

    public CucumberScenarioLoader(List<URI> featurePaths, TestStatistics statistics) {
        this.featurePaths = featurePaths;
        this.statistics = statistics;
    }

    public WeightedCucumberScenarios load() {
        LOGGER.debug("Feature paths are {}", this.featurePaths);
        Options featureOptions = () -> this.featurePaths;
        Parser gherkinParser = new Parser((Parser.Builder)new GherkinDocumentBuilder((IdGenerator)new IdGenerator.UUID()));
        TokenMatcher matcher = new TokenMatcher();
        FeaturePathFeatureSupplier supplier = new FeaturePathFeatureSupplier(this.classLoader, featureOptions, this.parser);
        IntStream.range(0, supplier.get().size()).forEach(i -> this.mapsForFeatures.put(((Messages.GherkinDocument.Builder)gherkinParser.parse(((Feature)supplier.get().get(i)).getSource(), (Parser.ITokenMatcher)matcher)).build().getFeature(), ((Feature)supplier.get().get(i)).getUri()));
        List<WeightedCucumberScenario> weightedCucumberScenarios = this.mapsForFeatures.keySet().stream().map(this.getScenarios()).flatMap(Collection::stream).collect(Collectors.toList());
        return new WeightedCucumberScenarios(weightedCucumberScenarios);
    }

    private Function<Messages.GherkinDocument.Feature, List<WeightedCucumberScenario>> getScenarios() {
        return cucumberFeature -> {
            try {
                return cucumberFeature == null ? Collections.emptyList() : cucumberFeature.getChildrenList().stream().filter(child -> child.hasScenario()).map(Messages.GherkinDocument.Feature.FeatureChild::getScenario).map(scenarioDefinition -> new WeightedCucumberScenario(PathUtils.getAsFile(this.mapsForFeatures.get(cucumberFeature)).getName(), cucumberFeature.getName(), scenarioDefinition.getName(), this.scenarioWeightFor((Messages.GherkinDocument.Feature)cucumberFeature, (Messages.GherkinDocument.Feature.Scenario)scenarioDefinition), this.tagsFor((Messages.GherkinDocument.Feature)cucumberFeature, (Messages.GherkinDocument.Feature.Scenario)scenarioDefinition), this.scenarioCountFor((Messages.GherkinDocument.Feature.Scenario)scenarioDefinition))).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Could not extract scenarios from %s", this.mapsForFeatures.get(cucumberFeature)), e);
            }
        };
    }

    private int scenarioCountFor(Messages.GherkinDocument.Feature.Scenario scenarioDefinition) {
        if (scenarioDefinition.getExamplesCount() > 0) {
            return scenarioDefinition.getExamplesList().stream().map(examples -> examples.getTableBodyList().size()).mapToInt(Integer::intValue).sum();
        }
        return 1;
    }

    private Set<String> tagsFor(Messages.GherkinDocument.Feature feature, Messages.GherkinDocument.Feature.Scenario scenarioDefinition) {
        return FluentIterable.concat((Iterable)feature.getTagsList(), this.scenarioTags(scenarioDefinition)).stream().map(Messages.GherkinDocument.Feature.Tag::getName).collect(Collectors.toSet());
    }

    private List<Messages.GherkinDocument.Feature.Tag> scenarioTags(Messages.GherkinDocument.Feature.Scenario scenario) {
        if (scenario.getExamplesCount() == 0) {
            return scenario.getTagsList();
        }
        return Stream.of(scenario.getTagsList(), scenario.getExamplesList().stream().flatMap(e -> e.getTagsList().stream()).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private BigDecimal scenarioWeightFor(Messages.GherkinDocument.Feature feature, Messages.GherkinDocument.Feature.Scenario scenarioDefinition) {
        return this.statistics.scenarioWeightFor(feature.getName(), scenarioDefinition.getName());
    }
}

