/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.LineFilters;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class FeaturePathFormatter {
    private LineFilters lineFilters = LineFilters.forCurrentContext();

    public URI featurePathWithPrefixIfNecessary(URI featurePath) {
        return this.lineFilters.getURIForFeaturePath(featurePath).map(matchingURI -> this.featurePathWithPrefix((URI)matchingURI, featurePath)).orElse(featurePath);
    }

    private URI featurePathWithPrefix(URI featurePathUri, URI featurePath) {
        Set<Integer> allLineNumbersSet = this.lineFilters.getLineNumbersFor(featurePathUri);
        ArrayList<Integer> allLineNumbersList = new ArrayList<Integer>(allLineNumbersSet);
        long featurePathPrefix = ((Integer)allLineNumbersList.get(0)).intValue();
        URI featureURIWithPrefix = featurePathUri;
        try {
            featureURIWithPrefix = new URI(featurePath.toString() + ":" + featurePathPrefix);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return featureURIWithPrefix;
    }

    private URI getURIForFeaturePath(Map<URI, Set<Integer>> map, URI featurePath) {
        for (URI currentURI : map.keySet()) {
            if (!featurePath.equals(currentURI)) continue;
            return currentURI;
        }
        return null;
    }
}

