/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.FeaturePathFormatter;
import io.cucumber.core.plugin.TestSourcesModel;
import io.cucumber.messages.Messages;
import io.cucumber.plugin.event.TestStep;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.DataTableRow;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.steps.StepEventBus;
import org.jetbrains.annotations.NotNull;

class ScenarioContext {
    private final Queue<Messages.GherkinDocument.Feature.Step> stepQueue = new LinkedList<Messages.GherkinDocument.Feature.Step>();
    private final Queue<TestStep> testStepQueue = new LinkedList<TestStep>();
    private boolean examplesRunning;
    private boolean addingScenarioOutlineSteps = false;
    private DataTable table;
    Map<Integer, Map<String, String>> exampleRows;
    Map<Integer, List<Messages.GherkinDocument.Feature.Tag>> exampleTags;
    int exampleCount = 0;
    boolean waitingToProcessBackgroundSteps = false;
    String currentScenarioId;
    Messages.GherkinDocument.Feature.Scenario currentScenarioDefinition;
    String currentScenario;
    List<Messages.GherkinDocument.Feature.Tag> featureTags = new ArrayList<Messages.GherkinDocument.Feature.Tag>();
    URI currentFeaturePath;
    private FeaturePathFormatter featurePathFormatter = new FeaturePathFormatter();

    ScenarioContext() {
    }

    public void currentFeaturePathIs(URI featurePath) {
        this.currentFeaturePath = featurePath;
    }

    public Messages.GherkinDocument.Feature.Scenario currentScenarioOutline() {
        return this.currentScenarioDefinition;
    }

    public URI currentFeaturePath() {
        return this.currentFeaturePath;
    }

    public Queue<Messages.GherkinDocument.Feature.Step> getStepQueue() {
        return this.stepQueue;
    }

    public boolean examplesAreRunning() {
        return this.examplesRunning;
    }

    public Map<Integer, Map<String, String>> getExampleRows() {
        return this.exampleRows;
    }

    public Map<Integer, List<Messages.GherkinDocument.Feature.Tag>> getExampleTags() {
        return this.exampleTags;
    }

    public int getExampleCount() {
        return this.exampleCount;
    }

    public DataTable getTable() {
        return this.table;
    }

    public boolean isWaitingToProcessBackgroundSteps() {
        return this.waitingToProcessBackgroundSteps;
    }

    public String getCurrentScenarioId() {
        return this.currentScenarioId;
    }

    public Messages.GherkinDocument.Feature.Scenario getCurrentScenarioDefinition() {
        return this.currentScenarioDefinition;
    }

    public String getCurrentScenario() {
        return this.currentScenario;
    }

    public List<Messages.GherkinDocument.Feature.Tag> getFeatureTags() {
        return this.featureTags;
    }

    public boolean isAddingScenarioOutlineSteps() {
        return this.addingScenarioOutlineSteps;
    }

    public void doneAddingScenarioOutlineSteps() {
        this.addingScenarioOutlineSteps = false;
    }

    public void setFeatureTags(List<Messages.GherkinDocument.Feature.Tag> tags) {
        this.featureTags = new ArrayList<Messages.GherkinDocument.Feature.Tag>(tags);
    }

    public void setCurrentScenarioDefinitionFrom(TestSourcesModel.AstNode astNode) {
        this.currentScenarioDefinition = TestSourcesModel.getScenarioDefinition((TestSourcesModel.AstNode)astNode);
    }

    public boolean isAScenarioOutline() {
        return this.currentScenarioDefinition.getExamplesCount() > 0;
    }

    public void startNewExample() {
        this.examplesRunning = true;
        this.addingScenarioOutlineSteps = true;
    }

    public void setExamplesRunning(boolean examplesRunning) {
        this.examplesRunning = examplesRunning;
    }

    public List<Messages.GherkinDocument.Feature.Tag> getScenarioTags() {
        return this.currentScenarioDefinition.getTagsList();
    }

    public String getScenarioName() {
        return this.currentScenarioDefinition.getName();
    }

    public List<Messages.GherkinDocument.Feature.Scenario.Examples> getScenarioExamples() {
        return this.currentScenarioDefinition.getExamplesList();
    }

    public void clearStepQueue() {
        this.stepQueue.clear();
    }

    public void clearTestStepQueue() {
        this.testStepQueue.clear();
    }

    public void queueStep(Messages.GherkinDocument.Feature.Step step) {
        this.stepQueue.add(step);
    }

    public void queueTestStep(TestStep testStep) {
        this.testStepQueue.add(testStep);
    }

    public Messages.GherkinDocument.Feature.Step getCurrentStep() {
        return this.stepQueue.peek();
    }

    public Messages.GherkinDocument.Feature.Step nextStep() {
        return this.stepQueue.poll();
    }

    public TestStep nextTestStep() {
        return this.testStepQueue.poll();
    }

    public boolean noStepsAreQueued() {
        return this.stepQueue.isEmpty();
    }

    public boolean hasScenarioId(String scenarioId) {
        return this.currentScenarioId != null && this.currentScenarioId.equals(scenarioId);
    }

    public void setTable(DataTable table) {
        this.table = table;
        this.exampleCount = table.getSize();
    }

    public void addTableRows(List<String> headers, List<Map<String, String>> rows, String name, String description, Map<Integer, Integer> lineNumbersOfEachRow) {
        this.table.startNewDataSet(name, description);
        AtomicInteger rowNumber = new AtomicInteger();
        rows.forEach(row -> this.table.appendRow(this.newRow(headers, lineNumbersOfEachRow, rowNumber.getAndIncrement(), (Map<String, String>)row)));
        this.table.updateLineNumbers(lineNumbersOfEachRow);
        this.exampleCount = this.table.getSize();
    }

    @NotNull
    private DataTableRow newRow(List<String> headers, Map<Integer, Integer> lineNumbersOfEachRow, int rowNumber, Map<String, String> row) {
        return new DataTableRow(this.rowValuesFrom(headers, row), lineNumbersOfEachRow.getOrDefault(rowNumber, 0).intValue());
    }

    private List<String> rowValuesFrom(List<String> headers, Map<String, String> row) {
        return headers.stream().map(row::get).collect(Collectors.toList());
    }

    public void addTableTags(List<TestTag> tags) {
        this.table.addTagsToLatestDataSet(tags);
    }

    public void clearTable() {
        this.table = null;
    }

    public StepEventBus stepEventBus() {
        URI prefixedPath = this.featurePathFormatter.featurePathWithPrefixIfNecessary(this.currentFeaturePath());
        return StepEventBus.eventBusFor((Object)prefixedPath);
    }
}

