/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.feature.Options;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.runtime.FeaturePathFeatureSupplier;
import io.cucumber.gherkin.CucumberScenarioLoader;
import io.cucumber.gherkin.GherkinDocumentBuilder;
import io.cucumber.gherkin.IncrementingIdGenerator;
import io.cucumber.gherkin.Parser;
import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Scenario;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.serenitybdd.cucumber.suiteslicing.TestScenarioResult;
import net.serenitybdd.cucumber.suiteslicing.TestStatistics;
import net.thucydides.model.util.Inflector;

public class ScenarioLineCountStatistics
implements TestStatistics {
    private final Supplier<ClassLoader> classLoader = CucumberScenarioLoader.class::getClassLoader;
    private final List<TestScenarioResult> results;

    private ScenarioLineCountStatistics(List<URI> featurePaths) {
        FeatureParser parser = new FeatureParser(UUID::randomUUID);
        Options featureOptions = () -> featurePaths;
        FeaturePathFeatureSupplier supplier = new FeaturePathFeatureSupplier(this.classLoader, featureOptions, parser);
        ArrayList<io.cucumber.messages.types.Feature> features = new ArrayList<io.cucumber.messages.types.Feature>();
        List gherkinFeatures = supplier.get();
        for (Feature gherkinFeature : gherkinFeatures) {
            Parser gherkinParser = new Parser((Parser.Builder)new GherkinDocumentBuilder((IdGenerator)new IncrementingIdGenerator(), gherkinFeature.getUri().toString()));
            GherkinDocument gherkinDocument = (GherkinDocument)gherkinParser.parse(gherkinFeature.getSource(), gherkinFeature.getUri().toString());
            features.add((io.cucumber.messages.types.Feature)gherkinDocument.getFeature().get());
        }
        this.results = features.stream().map(this.featureToScenarios()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static ScenarioLineCountStatistics fromFeaturePath(URI featurePaths) {
        return ScenarioLineCountStatistics.fromFeaturePaths(Arrays.asList(featurePaths));
    }

    public static ScenarioLineCountStatistics fromFeaturePaths(List<URI> featurePaths) {
        return new ScenarioLineCountStatistics(featurePaths);
    }

    private Function<io.cucumber.messages.types.Feature, List<TestScenarioResult>> featureToScenarios() {
        return cucumberFeature -> {
            try {
                return cucumberFeature == null ? Collections.emptyList() : cucumberFeature.getChildren().stream().filter(child -> child.getScenario() != null && child.getScenario().isPresent()).map(FeatureChild::getScenario).map(Optional::get).map(this.scenarioToResult((io.cucumber.messages.types.Feature)cucumberFeature)).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Could not extract scenarios from %s", cucumberFeature.getName()), e);
            }
        };
    }

    private Function<Scenario, TestScenarioResult> scenarioToResult(io.cucumber.messages.types.Feature feature) {
        return scenarioDefinition -> {
            try {
                return new TestScenarioResult(feature.getName(), scenarioDefinition.getName(), this.scenarioStepCountFor(this.backgroundStepCountFor(feature), (Scenario)scenarioDefinition));
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Could not determine step count for scenario '%s'", scenarioDefinition.getDescription()), e);
            }
        };
    }

    private BigDecimal scenarioStepCountFor(int backgroundStepCount, Scenario scenarioDefinition) {
        int stepCount;
        if (scenarioDefinition.getExamples().size() > 0) {
            Integer exampleCount = scenarioDefinition.getExamples().stream().map(examples -> examples.getTableBody().size()).mapToInt(Integer::intValue).sum();
            stepCount = exampleCount * (backgroundStepCount + scenarioDefinition.getSteps().size());
        } else {
            stepCount = backgroundStepCount + scenarioDefinition.getSteps().size();
        }
        return BigDecimal.valueOf(stepCount);
    }

    private int backgroundStepCountFor(io.cucumber.messages.types.Feature feature) {
        FeatureChild scenarioDefinition = (FeatureChild)feature.getChildren().get(0);
        if (scenarioDefinition.getBackground() != null && scenarioDefinition.getBackground().isPresent()) {
            return ((Background)scenarioDefinition.getBackground().get()).getSteps().size();
        }
        return 0;
    }

    @Override
    public BigDecimal scenarioWeightFor(String feature, String scenario) {
        return this.results.stream().filter(record -> record.feature.equals(feature) && record.scenario.equals(scenario)).map(TestScenarioResult::duration).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("no result found for scenario '%s' in feature '%s'", scenario, feature)));
    }

    @Override
    public List<TestScenarioResult> records() {
        return this.results;
    }

    public String toString() {
        return Inflector.getInstance().kebabCase(this.getClass().getSimpleName(), new char[0]);
    }
}

