/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.TestSourcesModel;
import io.cucumber.messages.types.Feature;
import io.cucumber.plugin.event.TestSourceRead;
import java.io.File;
import java.net.URI;
import java.util.Optional;
import net.thucydides.model.util.Inflector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureFileLoader {
    private final TestSourcesModel testSources = new TestSourcesModel();
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureFileLoader.class);

    private Optional<Feature> featureFrom(URI featureFileUri) {
        String defaultFeatureId = new File(featureFileUri).getName().replace(".feature", "");
        String defaultFeatureName = Inflector.getInstance().humanize(defaultFeatureId, new String[0]);
        this.parseGherkinIn(featureFileUri);
        if (StringUtils.isEmpty((CharSequence)this.testSources.getFeature(featureFileUri).getName())) {
            return Optional.empty();
        }
        Feature feature = this.testSources.getFeature(featureFileUri);
        if (feature.getName().isEmpty()) {
            feature = this.featureWithDefaultName(feature, defaultFeatureName);
        }
        return Optional.of(feature);
    }

    private void parseGherkinIn(URI featureFileUri) {
        try {
            this.testSources.getFeature(featureFileUri);
        }
        catch (Throwable ignoreParsingErrors) {
            LOGGER.warn("Could not parse the Gherkin in feature file " + String.valueOf(featureFileUri) + ": file ignored");
        }
    }

    public Feature featureWithDefaultName(Feature feature, String defaultName) {
        return new Feature(feature.getLocation(), feature.getTags(), feature.getLanguage(), feature.getKeyword(), defaultName, feature.getDescription(), feature.getChildren());
    }

    public void addTestSourceReadEvent(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.getUri(), event);
    }

    public String getFeatureName(URI featureFileUri) {
        return this.testSources.getFeature(featureFileUri).getName();
    }

    public Feature getFeature(URI featureFileUri) {
        return this.testSources.getFeature(featureFileUri);
    }

    TestSourcesModel.AstNode getAstNode(URI path, int line) {
        return this.testSources.getAstNode(path, line);
    }
}

