/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.exception.CucumberException;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.annotations.events.BeforeScenario;
import net.serenitybdd.core.lifecycle.LifecycleRegister;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.model.domain.TestOutcome;

public class SerenityObjectFactory
implements ObjectFactory {
    private final Set<Class<?>> classes = Collections.synchronizedSet(new HashSet());
    private final Map<Class<?>, Object> instances = Collections.synchronizedMap(new HashMap());

    public void start() {
    }

    public void stop() {
        this.instances.clear();
        Serenity.done((boolean)false);
    }

    public boolean addClass(Class<?> glueClass) {
        this.classes.add(glueClass);
        return true;
    }

    public <T> T getInstance(Class<T> type) {
        T instance = type.cast(this.instances.get(type));
        if (instance == null) {
            instance = this.cacheNewInstance(type);
        }
        return instance;
    }

    private <T> T cacheNewInstance(Class<T> type) {
        T instance = this.newInstance(type);
        this.instances.put(type, instance);
        return instance;
    }

    private <T> T newInstance(Class<T> type) {
        T instance;
        try {
            if (this.hasConstructorWithPagesParameter(type)) {
                instance = this.createNewPageEnabledStepCandidate(type);
            } else {
                Constructor<T> constructor = type.getConstructor(new Class[0]);
                instance = constructor.newInstance(new Object[0]);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new CucumberException(String.format("Failed to instantiate %s - this class doesn't have an empty or a page enabled constructor\"", type), (Throwable)e);
        }
        Serenity.initializeWithNoStepListener(instance).throwExceptionsImmediately();
        if (StepEventBus.getParallelEventBus().isBaseStepListenerRegistered()) {
            TestOutcome newTestOutcome = StepEventBus.getParallelEventBus().getBaseStepListener().getCurrentTestOutcome();
            LifecycleRegister.register(instance);
            LifecycleRegister.invokeMethodsAnnotatedBy(BeforeScenario.class, (TestOutcome)newTestOutcome);
        }
        return instance;
    }

    private <T> T createNewPageEnabledStepCandidate(Class<T> type) {
        T newInstance;
        try {
            ThucydidesWebDriverSupport.initialize();
            Pages pageFactory = ThucydidesWebDriverSupport.getPages();
            Class[] constructorArgs = new Class[]{Pages.class};
            Constructor<T> constructor = type.getConstructor(constructorArgs);
            newInstance = constructor.newInstance(pageFactory);
            Serenity.initialize(newInstance);
        }
        catch (Exception e) {
            throw new CucumberException(String.format("%s doesn't have an empty or a page enabled constructor.", type), (Throwable)e);
        }
        return newInstance;
    }

    private boolean hasConstructorWithPagesParameter(Class<?> type) {
        Class[] constructorArgs = new Class[]{Pages.class};
        try {
            type.getConstructor(constructorArgs);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }
}

