/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.suiteslicing;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import net.serenitybdd.core.time.Stopwatch;
import net.serenitybdd.cucumber.suiteslicing.TestScenarioResult;
import net.serenitybdd.cucumber.suiteslicing.TestStatistics;
import net.thucydides.core.util.Inflector;
import org.apache.commons.csv.CSVFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleRunTestStatistics
implements TestStatistics {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleRunTestStatistics.class);
    private final List<TestScenarioResult> records;
    private String fileName;
    private String[] headers;

    private SingleRunTestStatistics(String fileName) {
        Stopwatch timer = Stopwatch.started();
        this.fileName = fileName;
        this.headers = new String[]{"Story", "Title", "Result", "Date", "Stability", "Duration (s)"};
        this.records = this.records();
        LOGGER.debug("Loaded {} records from {} in {}", new Object[]{this.records.size(), fileName, timer.executionTimeFormatted()});
    }

    public static TestStatistics fromFileName(String fileName) {
        return new SingleRunTestStatistics(fileName);
    }

    @Override
    public BigDecimal scenarioWeightFor(String feature, String scenario) {
        return this.records.stream().filter(record -> record.feature.equals(feature) && record.scenario.equals(scenario)).map(TestScenarioResult::duration).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("no result found for feature %s and scenario %s", feature, scenario)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<TestScenarioResult> records() {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)Preconditions.checkNotNull((Object)this.getClass().getResourceAsStream(this.fileName), (Object)(this.fileName + " could not be found"))));){
            List<TestScenarioResult> list = CSVFormat.DEFAULT.withHeader(this.headers).withSkipHeaderRecord(true).parse((Reader)bufferedReader).getRecords().stream().map(TestScenarioResult::createFromCSV).collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(this.fileName + " could not be opened", e);
        }
    }

    public String toString() {
        return Inflector.getInstance().kebabCase(this.getClass().getSimpleName(), new char[0]);
    }
}

