/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.photography;

import java.util.HashMap;
import java.util.Map;
import net.serenitybdd.core.photography.PhotoLens;
import net.serenitybdd.core.photography.ScreenShooter;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.util.EnvironmentVariables;

public class ScreenShooterFactory {
    private final EnvironmentVariables environmentVariables;
    private static final Map<String, String> SCREEN_SHOOTER_SHORTCUTS = new HashMap<String, String>();

    public ScreenShooterFactory(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public ScreenShooter buildScreenShooter(PhotoLens lens) {
        String screenshooterClass = ThucydidesSystemProperty.SERENITY_SCREENSHOOTER.from(this.environmentVariables, "net.serenitybdd.core.photography.WebDriverScreenShooter");
        if (SCREEN_SHOOTER_SHORTCUTS.containsKey(screenshooterClass)) {
            screenshooterClass = SCREEN_SHOOTER_SHORTCUTS.get(screenshooterClass);
        }
        return this.newScreenShooter(lens, screenshooterClass);
    }

    private ScreenShooter newScreenShooter(PhotoLens lens, String screenshooterClass) {
        try {
            return (ScreenShooter)Class.forName(screenshooterClass).getConstructor(PhotoLens.class).newInstance(lens);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to instantiate screen shooter " + screenshooterClass, e);
        }
    }

    static {
        SCREEN_SHOOTER_SHORTCUTS.put("webdriver", "net.serenitybdd.core.photography.WebDriverScreenShooter");
        SCREEN_SHOOTER_SHORTCUTS.put("shutterbug", "net.serenitybdd.screenshots.shutterbug.ShutterbugScreenShooter");
        SCREEN_SHOOTER_SHORTCUTS.put("shutterbug1x", "net.serenitybdd.screenshots.shutterbug.Shutterbug1XScreenShooter");
    }
}

