/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.serenitybdd.model.environment.ConfiguredEnvironment;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.Listeners;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.steps.StepListener;
import net.thucydides.model.webdriver.Configuration;
import org.openqa.selenium.WebDriver;

public class SerenityListeners {
    private Configuration systemConfiguration;
    private final BaseStepListener baseStepListener;
    private final List<StepListener> stepListeners;

    public SerenityListeners(Configuration systemConfiguration) {
        this(StepEventBus.getParallelEventBus(), systemConfiguration);
    }

    public SerenityListeners(StepEventBus stepEventBus, Configuration systemConfiguration) {
        this.systemConfiguration = systemConfiguration;
        File outputDirectory = this.getSystemConfiguration().getOutputDirectory();
        this.baseStepListener = Listeners.getBaseStepListener().withOutputDirectory(outputDirectory);
        this.stepListeners = Arrays.asList(this.baseStepListener, Listeners.getLoggingListener());
        stepEventBus.dropAllListeners();
        this.registerListeners(stepEventBus);
    }

    private void registerListeners(StepEventBus stepEventBus) {
        stepEventBus.registerListener(this.baseStepListener);
        for (StepListener listener : this.stepListeners) {
            if (listener == null) continue;
            stepEventBus.registerListener(listener);
        }
    }

    public SerenityListeners withDriver(WebDriver driver) {
        this.baseStepListener.setDriver(driver);
        return this;
    }

    public BaseStepListener getBaseStepListener() {
        return this.baseStepListener;
    }

    public List<TestOutcome> getResults() {
        return new ArrayList<TestOutcome>(this.baseStepListener.getTestOutcomes());
    }

    protected Configuration getSystemConfiguration() {
        if (this.systemConfiguration == null) {
            this.systemConfiguration = ConfiguredEnvironment.getConfiguration();
        }
        return this.systemConfiguration;
    }
}

