/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.lifecycle;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.serenitybdd.model.exceptions.TestCompromisedException;
import net.thucydides.model.domain.TestOutcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleRegister {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifecycleRegister.class);
    private static final ThreadLocal<Set<Object>> registeredObjects = ThreadLocal.withInitial(HashSet::new);

    public static void register(Object object) {
        registeredObjects.get().add(object);
    }

    public static void clear() {
        registeredObjects.get().clear();
    }

    public static void invokeMethodsAnnotatedBy(Class<? extends Annotation> lifecycleAnnotation, TestOutcome outcome) {
        List matchingObjects = registeredObjects.get().stream().filter(object -> LifecycleRegister.hasAnnotatedMethod(object, lifecycleAnnotation)).collect(Collectors.toList());
        for (Object object2 : matchingObjects) {
            LifecycleRegister.invokeAnnotatedMethods(object2, lifecycleAnnotation, outcome);
        }
    }

    private static boolean hasAnnotatedMethod(Object object, Class<? extends Annotation> lifecycleAnnotation) {
        return Arrays.stream(object.getClass().getMethods()).anyMatch(method -> method.getDeclaredAnnotation(lifecycleAnnotation) != null);
    }

    private static void invokeAnnotatedMethods(Object object, Class<? extends Annotation> lifecycleAnnotation, TestOutcome outcome) {
        List annotatedMethods = Arrays.stream(object.getClass().getMethods()).filter(method -> method.getDeclaredAnnotation(lifecycleAnnotation) != null).collect(Collectors.toList());
        for (Method method2 : annotatedMethods) {
            LifecycleRegister.invoke(object, method2, outcome);
        }
    }

    private static void invoke(Object object, Method method, TestOutcome outcome) {
        try {
            if (method.getParameterTypes().length == 0) {
                method.invoke(object, new Object[0]);
            } else if (method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == TestOutcome.class) {
                method.invoke(object, outcome);
            } else {
                LOGGER.warn("Invalid signature for " + method.getName() + ": Serenity lifecycle-annotated methods should have either no parameters or a single parameter of type TestOutcome");
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new TestCompromisedException("Lifecycle method failure in " + String.valueOf(method), (Throwable)e);
        }
    }
}

