/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.capabilities;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.openqa.selenium.remote.AbstractDriverOptions;

public class SetCommonBrowserOptions {
    private final Map<String, Object> specifiedOptions;

    public SetCommonBrowserOptions(Map<String, Object> specifiedOptions) {
        this.specifiedOptions = specifiedOptions;
    }

    public static SetCommonBrowserOptions from(Map<String, Object> specifiedOptions) {
        return new SetCommonBrowserOptions(specifiedOptions);
    }

    public static List<String> propertyNames() {
        return Arrays.asList("proxy", "acceptInsecureCerts", "pageLoadStrategy", "strictFileInteractability", "unhandledPromptBehaviour");
    }

    public void in(AbstractDriverOptions options) {
        Iterator<String> iterator = this.specifiedOptions.keySet().iterator();
        while (iterator.hasNext()) {
            String optionName;
            switch (optionName = iterator.next()) {
                case "proxy": {
                    options.setProxy((Proxy)this.specifiedOptions.get("proxy"));
                    break;
                }
                case "acceptInsecureCerts": {
                    options.setAcceptInsecureCerts(Boolean.parseBoolean(this.specifiedOptions.get("acceptInsecureCerts").toString()));
                    break;
                }
                case "pageLoadStrategy": {
                    options.setPageLoadStrategy(PageLoadStrategy.fromString((String)this.specifiedOptions.get("pageLoadStrategy").toString()));
                    break;
                }
                case "strictFileInteractability": {
                    options.setStrictFileInteractability(Boolean.parseBoolean(this.specifiedOptions.get("strictFileInteractability").toString()));
                    break;
                }
                case "unhandledPromptBehavior": {
                    options.setUnhandledPromptBehaviour(UnexpectedAlertBehaviour.fromString((String)this.specifiedOptions.get("unhandledPromptBehavior").toString()));
                }
            }
        }
    }
}

