/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.util.ArrayList;
import net.serenitybdd.model.di.ModelInfrastructure;
import net.thucydides.model.ThucydidesSystemProperty;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;

public class TestContext {
    private static ThreadLocal<TestContext> LOCAL_TEST_CONTEXT = ThreadLocal.withInitial(TestContext::new);
    private String browserName;
    private String platform;

    public static TestContext forTheCurrentTest() {
        return LOCAL_TEST_CONTEXT.get();
    }

    public void recordBrowser(String browserName) {
        if (browserName != null) {
            this.browserName = browserName;
        }
    }

    public void recordPlatform(String platform) {
        if (platform != null) {
            this.platform = platform;
        }
    }

    public String getContext() {
        ArrayList<String> contextItems = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)this.browserName)) {
            contextItems.add(this.browserName.toLowerCase());
        }
        if (StringUtils.isNotBlank((CharSequence)this.platform)) {
            contextItems.add(this.platform.toLowerCase());
        } else if (ThucydidesSystemProperty.SERENITY_ADD_OS_TAG.booleanFrom(ModelInfrastructure.getEnvironmentVariables()).booleanValue()) {
            contextItems.add(this.currentPlatform());
        }
        return String.join((CharSequence)",", contextItems);
    }

    private String currentPlatform() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return "windows";
        }
        if (osName.startsWith("Mac")) {
            return "mac";
        }
        if (osName.startsWith("Linux")) {
            return "linux";
        }
        return osName;
    }

    public void recordCurrentPlatform() {
        this.recordPlatform(this.currentPlatform());
    }

    public void recordBrowserConfiguration(Capabilities options) {
        this.recordBrowser(options.getBrowserName());
    }

    public void recordBrowserAndPlatformConfiguration(Capabilities options) {
        this.recordBrowser(options.getBrowserName());
        if (options.getPlatformName() != null) {
            this.recordPlatform(options.getPlatformName().name());
        }
    }
}

