/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import com.google.common.eventbus.Subscribe;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.net.URL;
import net.serenitybdd.core.di.SerenityInfrastructure;
import net.serenitybdd.core.webdriver.appium.AppiumDevicePool;
import net.serenitybdd.core.webdriver.appium.AppiumServerPool;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.model.buildinfo.DriverCapabilityRecord;
import net.thucydides.core.events.TestLifecycleEvents;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.TestContext;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.DriverConfigurationError;
import net.thucydides.core.webdriver.MobilePlatform;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.WebDriverInstanceEventListener;
import net.thucydides.core.webdriver.WebDriverInstanceEvents;
import net.thucydides.core.webdriver.appium.AppiumConfiguration;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.util.EnvironmentVariables;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppiumDriverProvider
implements DriverProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppiumDriverProvider.class);
    private final DriverCapabilityRecord driverProperties;
    private final FixtureProviderService fixtureProviderService;

    public AppiumDriverProvider(FixtureProviderService fixtureProviderService) {
        this.fixtureProviderService = fixtureProviderService;
        this.driverProperties = SerenityInfrastructure.getDriverCapabilityRecord();
    }

    @Override
    public WebDriver newInstance(String options, EnvironmentVariables environmentVariables) {
        if (ThucydidesSystemProperty.MANAGE_APPIUM_SERVERS.booleanFrom(environmentVariables, Boolean.valueOf(false)).booleanValue()) {
            return this.newDriverUsingManagedAppiumServers(options, environmentVariables);
        }
        return this.newDriverUsingExternalServer(options, environmentVariables);
    }

    private WebDriver newDriverUsingExternalServer(String options, EnvironmentVariables environmentVariables) {
        CapabilityEnhancer enhancer = new CapabilityEnhancer(environmentVariables, this.fixtureProviderService);
        if (StepEventBus.getParallelEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        switch (this.appiumTargetPlatform(environmentVariables)) {
            case ANDROID: {
                AndroidDriver androidDriver = new AndroidDriver(this.appiumUrl(environmentVariables), (Capabilities)enhancer.enhanced((MutableCapabilities)this.appiumCapabilities(options, environmentVariables), SupportedWebDriver.ANDROID));
                this.driverProperties.registerCapabilities("appium", this.capabilitiesToProperties(androidDriver.getCapabilities()));
                return androidDriver;
            }
            case IOS: {
                IOSDriver iosDriver = new IOSDriver(this.appiumUrl(environmentVariables), (Capabilities)enhancer.enhanced((MutableCapabilities)this.appiumCapabilities(options, environmentVariables), SupportedWebDriver.IPHONE));
                this.driverProperties.registerCapabilities("appium", this.capabilitiesToProperties(iosDriver.getCapabilities()));
                return iosDriver;
            }
        }
        throw new DriverConfigurationError(this.appiumTargetPlatform(environmentVariables).name());
    }

    public WebDriver newDriverUsingManagedAppiumServers(String options, EnvironmentVariables environmentVariables) {
        LOGGER.info("Creating a new appium driver instance with options " + options);
        EnvironmentVariables testEnvironmentVariables = environmentVariables.copy();
        String deviceName = AppiumDevicePool.instance(testEnvironmentVariables).requestDevice();
        LOGGER.info("  - Using deviceName " + deviceName);
        URL appiumUrl = this.appiumUrl(testEnvironmentVariables, deviceName);
        LOGGER.info("  - Using appium server at " + String.valueOf(appiumUrl));
        testEnvironmentVariables.setProperty(ThucydidesSystemProperty.APPIUM_DEVICE_NAME.getPropertyName(), deviceName);
        testEnvironmentVariables.setProperty(ThucydidesSystemProperty.APPIUM_UDID.getPropertyName(), deviceName);
        testEnvironmentVariables.clearProperty(ThucydidesSystemProperty.APPIUM_DEVICE_NAMES.getPropertyName());
        CapabilityEnhancer enhancer = new CapabilityEnhancer(testEnvironmentVariables, this.fixtureProviderService);
        if (StepEventBus.getParallelEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        switch (this.appiumTargetPlatform(testEnvironmentVariables)) {
            case ANDROID: {
                LOGGER.info("  - Using android appium server at " + String.valueOf(appiumUrl));
                AndroidDriver androidDriver = null;
                try {
                    MutableCapabilities enhancedOptions = enhancer.enhanced((MutableCapabilities)this.appiumCapabilities(options, testEnvironmentVariables), SupportedWebDriver.ANDROID);
                    LOGGER.info("  - Using appium capabilities " + String.valueOf(enhancedOptions));
                    TestContext.forTheCurrentTest().recordBrowserConfiguration((Capabilities)enhancedOptions);
                    TestContext.forTheCurrentTest().recordCurrentPlatform();
                    androidDriver = new AndroidDriver(appiumUrl, (Capabilities)enhancedOptions);
                }
                catch (Throwable e) {
                    LOGGER.error("Creating ANDROID Driver failed " + String.valueOf(androidDriver), e);
                    throw e;
                }
                this.driverProperties.registerCapabilities("appium", this.capabilitiesToProperties(androidDriver.getCapabilities()));
                WebDriverInstanceEvents.bus().register(this.listenerFor((WebDriver)androidDriver, deviceName));
                LOGGER.info("  -> driver created" + String.valueOf(androidDriver));
                return androidDriver;
            }
            case IOS: {
                LOGGER.info("  - Using ios appium server at " + String.valueOf(appiumUrl));
                MutableCapabilities enhancedOptions = enhancer.enhanced((MutableCapabilities)this.appiumCapabilities(options, testEnvironmentVariables), SupportedWebDriver.IPHONE);
                LOGGER.info("  - Using appium capabilities " + String.valueOf(enhancedOptions));
                TestContext.forTheCurrentTest().recordBrowserConfiguration((Capabilities)enhancedOptions);
                TestContext.forTheCurrentTest().recordCurrentPlatform();
                IOSDriver iosDriver = new IOSDriver(appiumUrl, (Capabilities)enhancedOptions);
                this.driverProperties.registerCapabilities("appium", this.capabilitiesToProperties(iosDriver.getCapabilities()));
                WebDriverInstanceEvents.bus().register(this.listenerFor((WebDriver)iosDriver, deviceName));
                LOGGER.info("  -> driver created" + String.valueOf(iosDriver));
                return iosDriver;
            }
        }
        throw new DriverConfigurationError(this.appiumTargetPlatform(testEnvironmentVariables).name());
    }

    private DesiredCapabilities appiumCapabilities(String options, EnvironmentVariables environmentVariables) {
        return AppiumConfiguration.from(environmentVariables).getCapabilities(options);
    }

    private MobilePlatform appiumTargetPlatform(EnvironmentVariables environmentVariables) {
        return AppiumConfiguration.from(environmentVariables).getTargetPlatform();
    }

    private URL appiumUrl(EnvironmentVariables environmentVariables, String deviceName) {
        return AppiumServerPool.instance(environmentVariables).urlFor(deviceName);
    }

    private URL appiumUrl(EnvironmentVariables environmentVariables) {
        return AppiumConfiguration.from(environmentVariables).getUrl();
    }

    private WebDriverInstanceEventListener listenerFor(WebDriver driver, String deviceName) {
        return new AppiumEventListener(driver, deviceName);
    }

    private static class AppiumEventListener
    implements WebDriverInstanceEventListener {
        private final String deviceName;
        private WebDriver appiumDriver;
        private final AppiumDevicePool devicePool;
        private final Thread currentThread;

        private AppiumEventListener(WebDriver appiumDriver, String deviceName, AppiumDevicePool devicePool) {
            this.appiumDriver = appiumDriver;
            this.deviceName = deviceName;
            this.devicePool = devicePool;
            this.currentThread = Thread.currentThread();
            TestLifecycleEvents.register(this);
        }

        @Subscribe
        public void testFinishes(TestLifecycleEvents.TestFinished testFinished) {
            LOGGER.info("Appium test finished - releasing all devices");
            this.releaseAllDevicesUsedInThread(Thread.currentThread());
        }

        @Subscribe
        public void testSuiteFinishes(TestLifecycleEvents.TestSuiteFinished testSuiteFinished) {
            LOGGER.info("Appium test suite finished - shutting down servers");
            this.shutdownAllAppiumServersUsedInThread(Thread.currentThread());
        }

        private AppiumEventListener(WebDriver appiumDriver, String deviceName) {
            this(appiumDriver, deviceName, AppiumDevicePool.instance());
        }

        @Override
        public void close(WebDriver driver) {
            this.quit(driver);
        }

        @Override
        public void quit(WebDriver driver) {
            if (this.appiumDriver == driver) {
                this.devicePool.freeDevice(this.deviceName);
                this.appiumDriver = null;
            }
        }

        void releaseAllDevicesUsedInThread(Thread thread) {
            if (this.appiumDriver != null && this.currentThread == thread) {
                this.devicePool.freeDevice(this.deviceName);
                this.appiumDriver = null;
            }
        }

        void shutdownAllAppiumServersUsedInThread(Thread thread) {
            AppiumServerPool.instance().shutdownAllServersRunningOnThread(thread);
        }
    }
}

