/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.webdriver.driverproviders.DriverArgs;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.util.EnvironmentVariables;
import org.openqa.selenium.chromium.ChromiumOptions;

public class EnvironmentSwitches {
    private final EnvironmentVariables environmentVariables;

    EnvironmentSwitches(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public static EnvironmentSwitches from(EnvironmentVariables environmentVariables) {
        return new EnvironmentSwitches(environmentVariables);
    }

    public void addEnvironmentSwitchesTo(ChromiumOptions<?> options) {
        Optional headless;
        List<String> arguments = DriverArgs.fromProperty(ThucydidesSystemProperty.CHROME_SWITCHES).configuredIn(this.environmentVariables);
        if (!arguments.isEmpty()) {
            options.addArguments(arguments);
        }
        if ((headless = EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getOptionalProperty(ThucydidesSystemProperty.HEADLESS_MODE)).isPresent() && Boolean.parseBoolean((String)headless.get())) {
            options.addArguments(new String[]{"--headless"});
        }
    }
}

