/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.lang.reflect.Method;
import net.thucydides.model.steps.StepArgumentWriter;
import net.thucydides.model.util.Inflector;
import org.apache.commons.lang3.StringUtils;

public class StepNamer {
    public static String nameFor(Method method, Object[] args) {
        if (StepNamer.isScreenplayPerformAs(method)) {
            return StepNamer.screenplayStepWithArgs(method, args[0]);
        }
        if (args == null || args.length == 0) {
            return method.getName();
        }
        return StepNamer.testNameWithArguments(method, args);
    }

    private static String screenplayStepWithArgs(Method method, Object actor) {
        String taskName = Inflector.inflection().humanize(Inflector.inflection().underscore(method.getDeclaringClass().getSimpleName(), new char[0]), new String[0]);
        return Inflector.inflection().capitalize(actor.toString()) + " " + StringUtils.uncapitalize((String)taskName);
    }

    private static boolean isScreenplayPerformAs(Method method) {
        return method.getName().equals("performAs") && method.getParameterCount() == 1;
    }

    private static String testNameWithArguments(Method method, Object[] args) {
        StringBuilder testName = new StringBuilder(method.getName());
        testName.append(": ");
        boolean isFirst = true;
        for (Object arg : args) {
            if (!isFirst) {
                testName.append(", ");
            }
            testName.append(StepArgumentWriter.readableFormOf((Object)arg));
            isFirst = false;
        }
        return testName.toString();
    }
}

