/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.reports;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Optional;
import net.serenitybdd.core.reports.AddReportContentEvent;
import net.serenitybdd.core.reports.AndContent;
import net.serenitybdd.core.reports.FromFile;
import net.serenitybdd.core.reports.WithTitle;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.ReportData;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.session.TestSession;

public class ReportDataSaver
implements WithTitle,
AndContent,
FromFile {
    private final StepEventBus eventBus;
    private String title;
    private boolean fileIsDownloadable = false;
    private boolean isEvidence = false;

    public ReportDataSaver(StepEventBus eventBus) {
        this.eventBus = eventBus;
    }

    @Override
    public AndContent withTitle(String title) {
        this.title = title;
        return this;
    }

    @Override
    public void andContents(String contents) {
        if (!TestSession.isSessionStarted()) {
            this.doAddContents(contents);
        } else {
            TestSession.addEvent(new AddReportContentEvent(this, contents));
        }
    }

    public void doAddContents(String contents) {
        this.eventBus.getBaseStepListener().latestTestOutcome().ifPresent(outcome -> this.currentStepOrBackgroundIn((TestOutcome)outcome).withReportData(ReportData.withTitle((String)this.title).andContents(contents).asEvidence(Boolean.valueOf(this.isEvidence))));
    }

    private TestStep currentStepOrBackgroundIn(TestOutcome outcome) {
        if (outcome.currentStep().isPresent()) {
            return (TestStep)outcome.currentStep().get();
        }
        return (TestStep)outcome.recordStep(TestStep.forStepCalled((String)"Background").withResult(TestResult.SUCCESS)).currentStep().get();
    }

    @Override
    public void fromFile(Path source) throws IOException {
        Charset encoding = Charset.forName(ThucydidesSystemProperty.SERENITY_REPORT_ENCODING.from(this.eventBus.getEnvironmentVariables(), StandardCharsets.UTF_8.name()));
        this.fromFile(source, encoding);
    }

    @Override
    public void fromFile(Path source, Charset encoding) throws IOException {
        Optional<TestOutcome> outcome = this.eventBus.getBaseStepListener().latestTestOutcome();
        if (outcome.isPresent()) {
            ReportData reportData = this.fileIsDownloadable ? ReportData.withTitle((String)this.title).fromPath(source).asEvidence(Boolean.valueOf(this.isEvidence)) : ReportData.withTitle((String)this.title).fromFile(source, encoding).asEvidence(Boolean.valueOf(this.isEvidence));
            ((TestStep)outcome.get().currentStep().get()).withReportData(reportData);
        }
    }

    @Override
    public FromFile downloadable() {
        this.fileIsDownloadable = true;
        return this;
    }

    @Override
    public WithTitle asEvidence() {
        this.isEvidence = true;
        return this;
    }
}

