/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.photography;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.serenitybdd.core.photography.DarkroomFileSystem;
import net.serenitybdd.core.photography.DarkroomProcessingLine;
import net.serenitybdd.core.photography.PhotoFilter;
import net.serenitybdd.core.photography.ScreenshotNegative;
import net.serenitybdd.core.photography.ScreenshotReceipt;
import net.serenitybdd.core.photography.bluring.Blurer;
import net.serenitybdd.core.photography.resizing.Resizer;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Darkroom {
    private static final Logger LOGGER = LoggerFactory.getLogger(Darkroom.class);
    private static final List<PhotoFilter> DEFAULT_PROCESSORS = Arrays.asList(new Blurer());
    private DarkroomProcessingLine processingLine;
    private Thread screenshotThread;
    private final EnvironmentVariables environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();

    public void isOpenForBusiness() {
        if (this.theDarkroomIsClosed()) {
            LOGGER.debug("Opening darkroom");
            this.start();
        }
    }

    private boolean theDarkroomIsClosed() {
        return !this.theDarkroomIsOpen();
    }

    private List<? extends PhotoFilter> getProcessors() {
        ArrayList<PhotoFilter> processors = new ArrayList<PhotoFilter>();
        if (ThucydidesSystemProperty.SERENITY_COMPRESS_SCREENSHOTS.booleanFrom(this.environmentVariables, Boolean.valueOf(false)).booleanValue()) {
            processors.add(new Resizer());
        }
        processors.addAll(DEFAULT_PROCESSORS);
        return processors;
    }

    private boolean theDarkroomIsOpen() {
        return this.processingLine != null && this.processingLine.openForBusiness;
    }

    public void waitUntilClose() {
        LOGGER.debug("Closing darkroom");
        if (this.theDarkroomIsOpen()) {
            this.terminate();
        }
    }

    public void start() {
        this.processingLine = new DarkroomProcessingLine(this.getProcessors());
        this.screenshotThread = new Thread((Runnable)this.processingLine, "Darkroom Processing Line");
        this.screenshotThread.setDaemon(true);
        this.screenshotThread.start();
    }

    public void terminate() {
        if (this.processingLine != null) {
            this.shutdownProcessingLine();
        }
        DarkroomFileSystem.close();
    }

    public ScreenshotReceipt submitForProcessing(ScreenshotNegative negative) {
        this.ensureThatTheProcessingLineIsRunning();
        return this.processingLine.addToProcessingQueue(negative);
    }

    private void ensureThatTheProcessingLineIsRunning() {
        if (this.processingLine == null) {
            this.start();
        }
    }

    private void shutdownProcessingLine() {
        this.processingLine.terminate();
        try {
            this.screenshotThread.join();
        }
        catch (InterruptedException e) {
            LOGGER.error("Screenshot processing interrupted", (Throwable)e);
        }
    }

    public ScreenshotReceipt sendNegative(ScreenshotNegative screenshotNegative) {
        LOGGER.debug("Send negative for processing for " + screenshotNegative.getScreenshotPath());
        return this.submitForProcessing(screenshotNegative);
    }
}

