/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps.stepdata;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.thucydides.core.csv.FailedToInitializeTestData;
import net.thucydides.core.csv.FieldName;
import net.thucydides.core.csv.InstanceBuilder;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.stepdata.TestDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringTestDataSource
implements TestDataSource {
    private char separator = (char)44;
    private final String header;
    private final List<String> rows;
    private static final Logger LOGGER = LoggerFactory.getLogger(StringTestDataSource.class);

    public StringTestDataSource(String ... rows) {
        List<String> rowData = Arrays.asList(rows);
        this.header = rowData.get(0);
        this.rows = rowData.subList(1, rowData.size());
    }

    private Map<String, String> dataEntryFrom(List<String> titleRow, List<String> dataRow) {
        HashMap<String, String> dataset = new HashMap<String, String>();
        for (int column = 0; column < titleRow.size(); ++column) {
            if (column >= dataRow.size()) continue;
            String title = titleRow.get(column).trim();
            String value = dataRow.get(column).trim();
            dataset.put(title, value);
        }
        return dataset;
    }

    @Override
    public List<Map<String, String>> getData() {
        return this.loadTestDataFrom(this.getRows());
    }

    public List<List<String>> getRows() {
        ArrayList<List<String>> expandedRows = new ArrayList<List<String>>();
        for (String row : this.rows) {
            expandedRows.add(Splitter.on((char)this.separator).trimResults().splitToList((CharSequence)row));
        }
        return expandedRows;
    }

    public List<List<Object>> getRowsOfObjects() {
        ArrayList<List<Object>> expandedRows = new ArrayList<List<Object>>();
        for (String row : this.rows) {
            ArrayList rowData = new ArrayList(Splitter.on((char)this.separator).trimResults().splitToList((CharSequence)row));
            expandedRows.add(rowData);
        }
        return expandedRows;
    }

    @Override
    public List<String> getHeaders() {
        return Splitter.on((char)this.separator).trimResults().splitToList((CharSequence)this.header);
    }

    protected List<Map<String, String>> loadTestDataFrom(List<List<String>> rows) {
        ArrayList<Map<String, String>> loadedData = new ArrayList<Map<String, String>>();
        List<String> titleRow = this.getHeaders();
        for (List<String> dataRow : rows) {
            loadedData.add(this.dataEntryFrom(titleRow, dataRow));
        }
        return loadedData;
    }

    @Override
    public <T> List<T> getDataAsInstancesOf(Class<T> clazz, Object ... constructorArgs) {
        List<Map<String, String>> data = this.getData();
        ArrayList<T> resultsList = new ArrayList<T>();
        for (Map<String, String> rowData : data) {
            resultsList.add(this.newInstanceFrom(clazz, rowData, constructorArgs));
        }
        return resultsList;
    }

    @Override
    public <T> List<T> getInstanciatedInstancesFrom(Class<T> clazz, StepFactory factory) {
        List<Map<String, String>> data = this.getData();
        ArrayList<T> resultsList = new ArrayList<T>();
        for (Map<String, String> rowData : data) {
            resultsList.add(this.newInstanceFrom(clazz, factory, rowData));
        }
        return resultsList;
    }

    @Override
    public StringTestDataSource separatedBy(char newSeparator) {
        this.separator = newSeparator;
        return this;
    }

    private <T> T newInstanceFrom(Class<T> clazz, Map<String, String> rowData, Object ... constructorArgs) {
        T newObject = this.createNewInstanceOf(clazz, constructorArgs);
        this.assignPropertiesFromTestData(clazz, rowData, newObject);
        return newObject;
    }

    private <T> T newInstanceFrom(Class<T> clazz, StepFactory factory, Map<String, String> rowData) {
        T newObject = factory.getUniqueStepLibraryFor(clazz);
        this.assignPropertiesFromTestData(clazz, rowData, newObject);
        return newObject;
    }

    private <T> void assignPropertiesFromTestData(Class<T> clazz, Map<String, String> rowData, T newObject) {
        Set<String> propertyNames = rowData.keySet();
        boolean validPropertyFound = false;
        for (String columnHeading : propertyNames) {
            String value = rowData.get(columnHeading);
            String property = FieldName.from(columnHeading).inNormalizedForm();
            if (!this.assignPropertyValue(newObject, property, value)) continue;
            validPropertyFound = true;
        }
        if (!validPropertyFound) {
            throw new FailedToInitializeTestData("No properties or public fields matching the data columns were found or could be assigned for the class " + clazz.getName() + "using test data: " + rowData);
        }
    }

    protected <T> T createNewInstanceOf(Class<T> clazz, Object ... constructorArgs) {
        try {
            return InstanceBuilder.newInstanceOf(clazz, constructorArgs);
        }
        catch (Exception e) {
            LOGGER.error("Could not create test data bean", (Throwable)e);
            throw new FailedToInitializeTestData("Could not create test data beans", e);
        }
    }

    protected <T> boolean assignPropertyValue(T newObject, String property, String value) {
        boolean valueWasAssigned = true;
        try {
            InstanceBuilder.inObject(newObject).setPropertyValue(property, value);
        }
        catch (FailedToInitializeTestData e) {
            valueWasAssigned = false;
        }
        return valueWasAssigned;
    }
}

