/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps.interception;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.steps.ExampleTables;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.interception.StepInterceptionListener;

public class DynamicExampleStepInterceptionListener
implements StepInterceptionListener {
    @Override
    public void start(Object obj, Method method, Object[] args, Method zuperMethod) {
        if (ExampleTables.isUsingAnExampleTable() && TestAnnotations.isAnExampleStep((Method)method)) {
            List<String> headers = ExampleTables.getCurrentExampleTable().getHeaders();
            this.checkColumnCountFor(method, headers, args);
            HashMap<String, String> row = new HashMap<String, String>();
            int argumentIndex = 0;
            for (String header : headers) {
                row.put(header, args[argumentIndex++].toString());
            }
            StepEventBus.getParallelEventBus().exampleStarted(row);
        }
    }

    private void checkColumnCountFor(Method method, List<String> headers, Object[] args) {
        Preconditions.checkArgument((args.length >= headers.size() ? 1 : 0) != 0, (Object)("Missing column values for " + method + " (expecting values for: " + headers));
    }

    @Override
    public void end(Object obj, Method method, Object[] args, Method zuperMethod) {
        if (ExampleTables.isUsingAnExampleTable() && TestAnnotations.isAnExampleStep((Method)method)) {
            StepEventBus.getParallelEventBus().exampleFinished();
        }
    }
}

