/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.core.webdriver.driverproviders.AddLoggingPreferences;
import net.serenitybdd.core.webdriver.driverproviders.ConfiguredProxy;
import net.serenitybdd.core.webdriver.driverproviders.DriverArgs;
import net.serenitybdd.core.webdriver.driverproviders.DriverCapabilitiesProvider;
import net.serenitybdd.core.webdriver.driverproviders.SanitisedBrowserPreferences;
import net.serenitybdd.core.webdriver.driverproviders.SetProxyConfiguration;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.capabilities.BrowserPreferences;
import net.thucydides.core.webdriver.capabilities.W3CCapabilities;
import net.thucydides.core.webdriver.chrome.OptionsSplitter;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class EdgeDriverCapabilities
implements DriverCapabilitiesProvider {
    private final EnvironmentVariables environmentVariables;
    private final String driverOptions;

    public EdgeDriverCapabilities(EnvironmentVariables environmentVariables, String driverOptions) {
        this.environmentVariables = environmentVariables;
        this.driverOptions = driverOptions;
    }

    public DesiredCapabilities getCapabilities() {
        DesiredCapabilities edgeCaps = new DesiredCapabilities();
        edgeCaps.setCapability("ms:edgeChromium", true);
        HashMap<String, Object> edgeOptions = new HashMap<String, Object>();
        Map<String, Object> prefs = EdgeDriverCapabilities.preferencesConfiguredIn(this.environmentVariables);
        if (!prefs.isEmpty()) {
            edgeOptions.put("prefs", prefs);
        }
        List<String> args = EdgeDriverCapabilities.argsConfiguredIn(this.environmentVariables);
        args.addAll(DriverArgs.fromValue(this.driverOptions));
        if (!args.isEmpty()) {
            edgeOptions.put("args", args);
        }
        edgeCaps.setCapability("ms:edgeOptions", edgeOptions);
        DesiredCapabilities capabilities = new DesiredCapabilities((Capabilities)edgeCaps);
        capabilities.merge((Capabilities)W3CCapabilities.definedIn(this.environmentVariables).withPrefix("webdriver.capabilities").asDesiredCapabilities());
        AddLoggingPreferences.from(this.environmentVariables).to((MutableCapabilities)capabilities);
        SetProxyConfiguration.from(this.environmentVariables).in((MutableCapabilities)capabilities);
        return capabilities;
    }

    public EdgeOptions configuredOptions() {
        EdgeOptions options = new EdgeOptions();
        this.addProxyConfigurationTo(options);
        this.addPreferencesTo(options);
        this.addPageLoadStrategyTo(options);
        this.addRuntimeOptionsTo(options);
        return options;
    }

    private void addPreferencesTo(EdgeOptions options) {
        EdgeDriverCapabilities.preferencesConfiguredIn(this.environmentVariables).forEach((arg_0, arg_1) -> ((EdgeOptions)options).setCapability(arg_0, arg_1));
    }

    public static Map<String, Object> preferencesConfiguredIn(EnvironmentVariables environmentVariables) {
        return SanitisedBrowserPreferences.cleanUpPathsIn(BrowserPreferences.startingWith("edge.preferences.").from(environmentVariables));
    }

    public static List<String> argsConfiguredIn(EnvironmentVariables environmentVariables) {
        List<String> args = DriverArgs.fromProperty("edge.args").configuredIn(environmentVariables);
        Optional headless = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(ThucydidesSystemProperty.HEADLESS_MODE);
        if (headless.isPresent() && Boolean.parseBoolean((String)headless.get())) {
            args.add("headless");
        }
        return args;
    }

    private void addProxyConfigurationTo(EdgeOptions options) {
        ConfiguredProxy.definedIn(this.environmentVariables).ifPresent(arg_0 -> ((EdgeOptions)options).setProxy(arg_0));
    }

    private void addPageLoadStrategyTo(EdgeOptions options) {
        String pageLoadStrategyValue = ThucydidesSystemProperty.SERENITY_DRIVER_PAGE_LOAD_STRATEGY.from(this.environmentVariables);
        if (pageLoadStrategyValue != null) {
            PageLoadStrategy pageLoadStrategy = PageLoadStrategy.valueOf((String)pageLoadStrategyValue.toUpperCase());
            options.setPageLoadStrategy(pageLoadStrategy);
        }
    }

    private void addRuntimeOptionsTo(EdgeOptions options) {
        if (StringUtils.isNotEmpty((CharSequence)this.driverOptions)) {
            ArrayList<String> arguments = new ArrayList<String>(new OptionsSplitter().split(this.driverOptions));
            options.addArguments(arguments);
        }
        options.setAcceptInsecureCerts(ThucydidesSystemProperty.ACCEPT_INSECURE_CERTIFICATES.booleanFrom(this.environmentVariables, Boolean.valueOf(false)).booleanValue());
    }
}

